/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;

public class DeleteSecretAction
extends AbstractKubernetesAction {
    private final String secretName;

    public DeleteSecretAction(Builder builder) {
        super("delete-secret", builder);
        this.secretName = builder.secretName;
    }

    public void doExecute(TestContext context) {
        ((Resource)((NonNamespaceOperation)this.getKubernetesClient().secrets().inNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.secretName))).delete();
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<DeleteSecretAction, Builder> {
        private String secretName;

        public Builder secret(String secretName) {
            this.secretName = secretName;
            return this;
        }

        @Override
        public DeleteSecretAction doBuild() {
            return new DeleteSecretAction(this);
        }
    }
}

