/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateAnnotationsAction;
import org.citrusframework.kubernetes.actions.CreateConfigMapAction;
import org.citrusframework.kubernetes.actions.CreateCustomResourceAction;
import org.citrusframework.kubernetes.actions.CreateLabelsAction;
import org.citrusframework.kubernetes.actions.CreateResourceAction;
import org.citrusframework.kubernetes.actions.CreateSecretAction;
import org.citrusframework.kubernetes.actions.CreateServiceAction;
import org.citrusframework.kubernetes.actions.DeleteConfigMapAction;
import org.citrusframework.kubernetes.actions.DeleteCustomResourceAction;
import org.citrusframework.kubernetes.actions.DeleteResourceAction;
import org.citrusframework.kubernetes.actions.DeleteSecretAction;
import org.citrusframework.kubernetes.actions.DeleteServiceAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.actions.VerifyCustomResourceAction;
import org.citrusframework.kubernetes.actions.VerifyPodAction;
import org.citrusframework.kubernetes.actions.WatchPodLogsAction;
import org.springframework.util.Assert;

public class KubernetesActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<KubernetesAction> {
    private KubernetesClient kubernetesClient;
    private AbstractKubernetesAction.Builder<? extends KubernetesAction, ?> delegate;

    public static KubernetesActionBuilder k8s() {
        return KubernetesActionBuilder.kubernetes();
    }

    public static KubernetesActionBuilder kubernetes() {
        return new KubernetesActionBuilder();
    }

    public KubernetesActionBuilder client(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        return this;
    }

    public ServiceActionBuilder services() {
        return new ServiceActionBuilder();
    }

    public ResourceActionBuilder resources() {
        return new ResourceActionBuilder();
    }

    public DeploymentActionBuilder deployments() {
        return new DeploymentActionBuilder();
    }

    public PodActionBuilder pods() {
        return new PodActionBuilder();
    }

    public CustomResourceActionBuilder customResources() {
        return new CustomResourceActionBuilder();
    }

    public SecretActionBuilder secrets() {
        return new SecretActionBuilder();
    }

    public ConfigMapActionBuilder configMaps() {
        return new ConfigMapActionBuilder();
    }

    public KubernetesAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        if (this.kubernetesClient != null) {
            this.delegate.client(this.kubernetesClient);
        }
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public class ServiceActionBuilder {
        public CreateServiceAction.Builder create(String serviceName) {
            CreateServiceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateServiceAction.Builder)((Object)new CreateServiceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).service(serviceName);
            return builder;
        }

        public CreateAnnotationsAction.Builder addAnnotation(String serviceName) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).service(serviceName);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String serviceName) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).service(serviceName);
            return builder;
        }

        public DeleteServiceAction.Builder delete(String serviceName) {
            DeleteServiceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((DeleteServiceAction.Builder)((Object)new DeleteServiceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).service(serviceName);
            return builder;
        }
    }

    public class ResourceActionBuilder {
        public CreateResourceAction.Builder create() {
            CreateResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = (CreateResourceAction.Builder)((Object)new CreateResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient));
            return builder;
        }

        public CreateAnnotationsAction.Builder addAnnotation(String resourceName, String resourceType) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).resource(resourceName).type(resourceType);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String resourceName, String resourceType) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).resource(resourceName).type(resourceType);
            return builder;
        }

        public DeleteResourceAction.Builder delete(String content) {
            DeleteResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((DeleteResourceAction.Builder)((Object)new DeleteResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).content(content);
            return builder;
        }
    }

    public class DeploymentActionBuilder {
        public CreateAnnotationsAction.Builder addAnnotation(String deploymentName) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).deployment(deploymentName);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String deploymentName) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).deployment(deploymentName);
            return builder;
        }
    }

    public class PodActionBuilder {
        public VerifyPodAction.Builder verify(String podName) {
            VerifyPodAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyPodAction.Builder)((Object)new VerifyPodAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).podName(podName);
            return builder;
        }

        public WatchPodLogsAction.Builder watchLogs(String podName) {
            WatchPodLogsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((WatchPodLogsAction.Builder)((Object)new WatchPodLogsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).podName(podName);
            return builder;
        }

        public WatchPodLogsAction.Builder watchLogs(String label, String value) {
            WatchPodLogsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((WatchPodLogsAction.Builder)((Object)new WatchPodLogsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).label(label, value);
            return builder;
        }

        public CreateAnnotationsAction.Builder addAnnotation(String podName) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).pod(podName);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String podName) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).pod(podName);
            return builder;
        }

        public VerifyPodAction.Builder verify(String label, String value) {
            VerifyPodAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyPodAction.Builder)((Object)new VerifyPodAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).label(label, value);
            return builder;
        }
    }

    public class CustomResourceActionBuilder {
        public CreateCustomResourceAction.Builder create() {
            CreateCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = (CreateCustomResourceAction.Builder)((Object)new CreateCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient));
            return builder;
        }

        public DeleteCustomResourceAction.Builder delete(String name) {
            DeleteCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((DeleteCustomResourceAction.Builder)((Object)new DeleteCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).resourceName(name);
            return builder;
        }

        public VerifyCustomResourceAction.Builder verify() {
            VerifyCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = (VerifyCustomResourceAction.Builder)((Object)new VerifyCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient));
            return builder;
        }

        public VerifyCustomResourceAction.Builder verify(Class<? extends CustomResource<?, ?>> resourceType) {
            VerifyCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyCustomResourceAction.Builder)((Object)new VerifyCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).type(resourceType);
            return builder;
        }

        public VerifyCustomResourceAction.Builder verify(String name, Class<? extends CustomResource<?, ?>> resourceType) {
            VerifyCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyCustomResourceAction.Builder)((Object)new VerifyCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).type(resourceType).resourceName(name);
            return builder;
        }

        public VerifyCustomResourceAction.Builder verify(String name) {
            VerifyCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyCustomResourceAction.Builder)((Object)new VerifyCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).resourceName(name);
            return builder;
        }

        public VerifyCustomResourceAction.Builder verify(String label, String value) {
            VerifyCustomResourceAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((VerifyCustomResourceAction.Builder)((Object)new VerifyCustomResourceAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).label(label, value);
            return builder;
        }
    }

    public class SecretActionBuilder {
        public CreateSecretAction.Builder create(String secretName) {
            CreateSecretAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateSecretAction.Builder)((Object)new CreateSecretAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).secret(secretName);
            return builder;
        }

        public CreateAnnotationsAction.Builder addAnnotation(String secretName) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).secret(secretName);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String secretName) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).secret(secretName);
            return builder;
        }

        public DeleteSecretAction.Builder delete(String secretName) {
            DeleteSecretAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((DeleteSecretAction.Builder)((Object)new DeleteSecretAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).secret(secretName);
            return builder;
        }
    }

    public class ConfigMapActionBuilder {
        public CreateConfigMapAction.Builder create(String configMapName) {
            CreateConfigMapAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateConfigMapAction.Builder)((Object)new CreateConfigMapAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).configMap(configMapName);
            return builder;
        }

        public CreateAnnotationsAction.Builder addAnnotation(String configMapName) {
            CreateAnnotationsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateAnnotationsAction.Builder)((Object)new CreateAnnotationsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).configMap(configMapName);
            return builder;
        }

        public CreateLabelsAction.Builder addLabel(String configMapName) {
            CreateLabelsAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((CreateLabelsAction.Builder)((Object)new CreateLabelsAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).configMap(configMapName);
            return builder;
        }

        public DeleteConfigMapAction.Builder delete(String configMapName) {
            DeleteConfigMapAction.Builder builder;
            KubernetesActionBuilder.this.delegate = builder = ((DeleteConfigMapAction.Builder)((Object)new DeleteConfigMapAction.Builder().client(KubernetesActionBuilder.this.kubernetesClient))).configMap(configMapName);
            return builder;
        }
    }
}

