/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.KubernetesVariableNames;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;

public class KubernetesConnectAction
extends AbstractKubernetesAction
implements KubernetesAction {
    public KubernetesConnectAction(Builder builder) {
        super("kubernetes-connect", builder);
    }

    public void doExecute(TestContext context) {
        if (this.isDisabled(context)) {
            return;
        }
        context.setVariable(KubernetesVariableNames.CONNECTED.value(), (Object)true);
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<KubernetesConnectAction, Builder> {
        private String containerImage;
        private final Map<String, String> annotations = new HashMap<String, String>();
        private final Map<String, String> labels = new HashMap<String, String>();

        public Builder image(String containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public Builder annotations(Map<String, String> annotations) {
            this.annotations.putAll(annotations);
            return this;
        }

        public Builder annotation(String annotation, String value) {
            this.annotations.put(annotation, value);
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public Builder label(String label, String value) {
            this.labels.put(label, value);
            return this;
        }

        @Override
        public KubernetesConnectAction doBuild() {
            return new KubernetesConnectAction(this);
        }
    }
}

