/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.KubernetesSupport;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.springframework.util.StringUtils;

public class VerifyCustomResourceAction
extends AbstractKubernetesAction {
    private final String resourceName;
    private final String type;
    private final Class<? extends CustomResource<?, ?>> resourceType;
    private final String version;
    private final String kind;
    private final String group;
    private final String labelExpression;
    private final int maxAttempts;
    private final long delayBetweenAttempts;
    private final String condition;

    public VerifyCustomResourceAction(Builder builder) {
        super("verify-custom-resource-status", builder);
        this.resourceName = builder.resourceName;
        this.type = builder.type;
        this.resourceType = builder.resourceType;
        this.group = builder.group;
        this.version = builder.version;
        this.kind = builder.kind;
        this.labelExpression = builder.labelExpression;
        this.condition = builder.condition;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
    }

    public void doExecute(TestContext context) {
        this.verifyResource(context.replaceDynamicContentInString(this.resourceName), context.replaceDynamicContentInString(this.labelExpression), context.replaceDynamicContentInString(this.condition), context);
    }

    private void verifyResource(String name, String labelExpression, String condition, TestContext context) {
        for (int i = 0; i < this.maxAttempts; ++i) {
            HasMetadata resource = name != null && !name.isEmpty() ? this.getResource(name, condition, context) : this.getResourceFromLabel(labelExpression, condition, context);
            if (resource != null) {
                this.logger.info(String.format("Verified resource '%s' state '%s'!", this.getNameOrLabel(name, labelExpression), condition));
                return;
            }
            this.logger.warn(String.format("Waiting for resource '%s' in state '%s' - retry in %s ms", this.getNameOrLabel(name, labelExpression), condition, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for resource condition", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify resource '%s' - is not in state '%s' after %d attempts", this.getNameOrLabel(name, labelExpression), condition, this.maxAttempts)));
    }

    private HasMetadata getResource(String name, String condition, TestContext context) {
        if (this.resourceType != null) {
            CustomResource resource = (CustomResource)((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(this.resourceType).inNamespace(this.namespace(context))).withName(name)).get();
            if (resource.getStatus() != null) {
                return this.verifyResourceStatus((Map)KubernetesSupport.json().convertValue((Object)resource, Map.class), condition) ? resource : null;
            }
        } else {
            GenericKubernetesResource resource = KubernetesSupport.getResource(this.getKubernetesClient(), this.namespace(context), this.getCrdContext(context), name);
            return this.verifyResourceStatus(resource.getAdditionalProperties(), condition) ? resource : null;
        }
        return null;
    }

    private HasMetadata getResourceFromLabel(String labelExpression, String condition, TestContext context) {
        String labelValue;
        if (labelExpression == null || labelExpression.isEmpty()) {
            return null;
        }
        String[] tokens = labelExpression.split("=");
        String labelKey = tokens[0];
        String string = labelValue = tokens.length > 1 ? tokens[1] : "";
        if (this.resourceType != null) {
            KubernetesResourceList resourceList = (KubernetesResourceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().resources(this.resourceType).inNamespace(this.namespace(context))).withLabel(labelKey, labelValue)).list();
            for (CustomResource listItem : resourceList.getItems()) {
                if (listItem.getStatus() == null || !this.verifyResourceStatus((Map)KubernetesSupport.json().convertValue((Object)listItem, Map.class), condition)) continue;
                return listItem;
            }
        } else {
            GenericKubernetesResourceList resourceList = KubernetesSupport.getResources(this.getKubernetesClient(), this.namespace(context), this.getCrdContext(context), labelKey, labelValue);
            return resourceList.getItems().stream().filter(resource -> this.verifyResourceStatus(resource.getAdditionalProperties(), condition)).findFirst().orElse(null);
        }
        return null;
    }

    private boolean verifyResourceStatus(Map<String, Object> additionalProperties, String condition) {
        Map<String, Object> status = this.getAsPropertyMap("status", additionalProperties);
        List<Map<String, Object>> conditions = this.getAsPropertyList("conditions", status);
        return conditions.stream().anyMatch(propertyMap -> propertyMap.getOrDefault("type", "").equals(condition) && Optional.ofNullable(propertyMap.get("status")).map(b -> Boolean.valueOf(b.toString())).orElse(false) != false);
    }

    private ResourceDefinitionContext getCrdContext(TestContext context) {
        return KubernetesSupport.crdContext(context.replaceDynamicContentInString(this.type), context.replaceDynamicContentInString(this.group), context.replaceDynamicContentInString(this.kind), context.replaceDynamicContentInString(this.version));
    }

    private String getNameOrLabel(String name, String labelExpression) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return labelExpression;
    }

    private Map<String, Object> getAsPropertyMap(String property, Map<String, Object> objectMap) {
        if (objectMap != null && objectMap.containsKey(property) && objectMap.get(property) instanceof Map) {
            return (Map)objectMap.get(property);
        }
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> getAsPropertyList(String property, Map<String, Object> objectMap) {
        if (objectMap.containsKey(property) && objectMap.get(property) instanceof List) {
            return ((List)objectMap.get(property)).stream().map(item -> (Map)item).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static final class Builder
    extends AbstractKubernetesAction.Builder<VerifyCustomResourceAction, Builder> {
        private String resourceName;
        private String labelExpression;
        private int maxAttempts = KubernetesSettings.getMaxAttempts();
        private long delayBetweenAttempts = KubernetesSettings.getDelayBetweenAttempts();
        private String condition = "Ready";
        private String type;
        private Class<? extends CustomResource<?, ?>> resourceType;
        private String version = "v1";
        private String kind;
        private String group;

        public Builder resourceName(String name) {
            if (name.contains("/")) {
                String[] tokens = name.split("/");
                if (this.kind == null) {
                    this.kind(StringUtils.capitalize((String)tokens[0]));
                }
                this.resourceName = tokens.length > 1 ? tokens[1] : "";
            } else {
                this.resourceName = name;
            }
            return this;
        }

        public Builder resourceType(Class<CustomResource<?, ?>> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(Class<? extends CustomResource<?, ?>> resourceType) {
            this.version(resourceType.getAnnotation(Version.class).value());
            this.group(resourceType.getAnnotation(Group.class).value());
            this.kind(resourceType.getSimpleName());
            this.type(String.format("%ss.%s/%s", this.kind.toLowerCase(Locale.ENGLISH), this.group, this.version));
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(String resourceType) {
            if (resourceType.contains("/")) {
                String[] tokens = resourceType.split("/");
                this.type = tokens[0];
                if (this.group == null) {
                    this.group(this.type.substring(this.type.indexOf(".") + 1));
                }
                if (tokens.length > 1) {
                    this.version(tokens[1]);
                }
            } else {
                this.type = resourceType;
            }
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            String[] groupAndVersion = apiVersion.split("/");
            this.group(groupAndVersion[0]);
            this.version(groupAndVersion[1]);
            return this;
        }

        public Builder condition(String value) {
            this.condition = value;
            return this;
        }

        public Builder isAvailable() {
            this.condition("Available");
            return this;
        }

        public Builder isReady() {
            this.condition("Ready");
            return this;
        }

        public Builder label(String name, String value) {
            this.labelExpression = String.format("%s=%s", name, value);
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        @Override
        public VerifyCustomResourceAction doBuild() {
            return new VerifyCustomResourceAction(this);
        }
    }
}

