/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.KubernetesSupport;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPodAction
extends AbstractKubernetesAction {
    private static final Logger POD_STATUS_LOG = LoggerFactory.getLogger((String)"POD_STATUS");
    private static final Logger POD_LOG = LoggerFactory.getLogger((String)"POD_LOGS");
    private final String podName;
    private final String labelExpression;
    private final String logMessage;
    private final int maxAttempts;
    private final long delayBetweenAttempts;
    private final String phase;
    private final boolean printLogs;

    public VerifyPodAction(Builder builder) {
        super("verify-pod-status", builder);
        this.podName = builder.podName;
        this.labelExpression = builder.labelExpression;
        this.phase = builder.phase;
        this.logMessage = builder.logMessage;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
        this.printLogs = builder.printLogs;
    }

    public void doExecute(TestContext context) {
        String resolvedPodName = context.replaceDynamicContentInString(this.podName);
        String resolvedLabelExpression = context.replaceDynamicContentInString(this.labelExpression);
        Pod pod = this.verifyPod(resolvedPodName, resolvedLabelExpression, context.replaceDynamicContentInString(this.phase), this.namespace(context));
        if (this.logMessage != null) {
            this.verifyPodLogs(pod, this.getNameOrLabel(resolvedPodName, resolvedLabelExpression), this.namespace(context), context.replaceDynamicContentInString(this.logMessage));
        }
    }

    private void verifyPodLogs(Pod pod, String nameOrLabel, String namespace, String message) {
        if (this.printLogs) {
            POD_LOG.info(String.format("Waiting for pod '%s' to log message", nameOrLabel));
        }
        int offset = 0;
        for (int i = 0; i < this.maxAttempts; ++i) {
            String log = this.getPodLogs(pod, namespace);
            if (this.printLogs && offset < log.length()) {
                POD_LOG.info(log.substring(offset));
                offset = log.length();
            }
            if (log.contains(message)) {
                this.logger.info("Verified pod logs - All values OK!");
                return;
            }
            if (!this.printLogs) {
                this.logger.info(String.format("Waiting for pod '%s' to log message - retry in %s ms", nameOrLabel, this.delayBetweenAttempts));
            }
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for pod logs", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify pod '%s' - has not printed message '%s' after %d attempts", nameOrLabel, this.logMessage, this.maxAttempts)));
    }

    private String getPodLogs(Pod pod, String namespace) {
        PodResource podRes = (PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withName(pod.getMetadata().getName());
        String containerName = null;
        if (pod.getSpec() != null && pod.getSpec().getContainers() != null && pod.getSpec().getContainers().size() > 1) {
            containerName = ((Container)pod.getSpec().getContainers().get(0)).getName();
        }
        String logs = containerName != null ? ((ContainerResource)podRes.inContainer(containerName)).getLog() : podRes.getLog();
        return logs;
    }

    private Pod verifyPod(String name, String labelExpression, String phase, String namespace) {
        if (StringUtils.hasText((String)name)) {
            POD_STATUS_LOG.info(String.format("Waiting for pod '%s' to be in state '%s'", name, phase));
        } else {
            POD_STATUS_LOG.info(String.format("Waiting for pod with label '%s' to be in state '%s'", labelExpression, phase));
        }
        for (int i = 0; i < this.maxAttempts; ++i) {
            Pod pod = StringUtils.hasText((String)name) ? this.getPod(name, phase, namespace) : this.getPodFromLabel(labelExpression, phase, namespace);
            if (pod != null) {
                this.logger.info(String.format("Verified pod '%s' state '%s'!", this.getNameOrLabel(name, labelExpression), phase));
                return pod;
            }
            this.logger.info(String.format("Waiting for pod '%s' in state '%s' - retry in %s ms", this.getNameOrLabel(name, labelExpression), phase, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for pod state", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify pod '%s' - is not in state '%s' after %d attempts", this.getNameOrLabel(name, labelExpression), phase, this.maxAttempts)));
    }

    private Pod getPod(String name, String phase, String namespace) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withName(name)).get();
        boolean verified = KubernetesSupport.verifyPodStatus(pod, phase);
        if (!verified) {
            POD_STATUS_LOG.info(String.format("Pod '%s' not yet in state '%s'. Will keep checking ...", name, phase));
        }
        return verified ? pod : null;
    }

    private Pod getPodFromLabel(String labelExpression, String phase, String namespace) {
        if (labelExpression == null || labelExpression.isEmpty()) {
            return null;
        }
        String[] tokens = labelExpression.split("=");
        String labelKey = tokens[0];
        String labelValue = tokens.length > 1 ? tokens[1] : "";
        PodList pods = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withLabel(labelKey, labelValue)).list();
        if (pods.getItems().isEmpty()) {
            POD_STATUS_LOG.info(String.format("Integration with label '%s' not yet available. Will keep checking ...", labelExpression));
        }
        return pods.getItems().stream().filter(pod -> {
            boolean verified = KubernetesSupport.verifyPodStatus(pod, phase);
            if (!verified) {
                POD_STATUS_LOG.info(String.format("Pod with label '%s' not yet in state '%s'. Will keep checking ...", labelExpression, phase));
            }
            return verified;
        }).findFirst().orElse(null);
    }

    private String getNameOrLabel(String name, String labelExpression) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return labelExpression;
    }

    public static final class Builder
    extends AbstractKubernetesAction.Builder<VerifyPodAction, Builder> {
        private String podName;
        private String labelExpression;
        private String logMessage;
        private int maxAttempts = KubernetesSettings.getMaxAttempts();
        private long delayBetweenAttempts = KubernetesSettings.getDelayBetweenAttempts();
        private String phase = "Running";
        private boolean printLogs = true;

        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        public Builder isRunning() {
            this.phase = "Running";
            return this;
        }

        public Builder isStopped() {
            this.phase = "Stopped";
            return this;
        }

        public Builder printLogs(boolean printLogs) {
            this.printLogs = printLogs;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder label(String name, String value) {
            this.labelExpression = String.format("%s=%s", name, value);
            return this;
        }

        public Builder waitForLogMessage(String logMessage) {
            this.logMessage = logMessage;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        @Override
        public VerifyPodAction doBuild() {
            return new VerifyPodAction(this);
        }
    }
}

