/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.client;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.endpoint.KubernetesEndpointConfiguration;
import org.citrusframework.message.Message;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.Producer;
import org.citrusframework.messaging.ReplyConsumer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesClient.class);
    private final CorrelationManager<KubernetesCommand<?, ?>> correlationManager;

    public KubernetesClient() {
        this(new KubernetesEndpointConfiguration());
    }

    public KubernetesClient(KubernetesEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public KubernetesEndpointConfiguration getEndpointConfiguration() {
        return (KubernetesEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        logger.debug("Sending Kubernetes request to: '{}'", (Object)this.getEndpointConfiguration().getKubernetesClientConfig().getMasterUrl());
        KubernetesCommand<?, ?> command = this.getEndpointConfiguration().getMessageConverter().convertOutbound(message, this.getEndpointConfiguration(), context);
        command.execute(this, context);
        logger.info("Kubernetes request was sent to endpoint: '{}'", (Object)this.getEndpointConfiguration().getKubernetesClientConfig().getMasterUrl());
        this.correlationManager.store(correlationKey, command);
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        KubernetesCommand command = (KubernetesCommand)this.correlationManager.find(selector, timeout);
        if (command == null) {
            throw new MessageTimeoutException(timeout, this.getEndpointConfiguration().getKubernetesClientConfig().getMasterUrl());
        }
        if (command.getResultCallback() != null) {
            command.validateCommandResult(context);
        }
        return this.getEndpointConfiguration().getMessageConverter().convertInbound(command, this.getEndpointConfiguration(), context);
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public io.fabric8.kubernetes.client.KubernetesClient getClient() {
        return this.getEndpointConfiguration().getKubernetesClient();
    }
}

