/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.command.ListResult;
import org.citrusframework.util.StringUtils;

public abstract class AbstractListCommand<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>, C extends KubernetesCommand<T, ListResult<T>>>
extends AbstractClientCommand<T, ListResult<T>, L, R, C> {
    public AbstractListCommand(String name) {
        super("list-" + name);
    }

    @Override
    public void execute(MixedOperation<T, L, R> operation, TestContext context) {
        KubernetesResourceList list = (KubernetesResourceList)operation.list();
        ListResult result = new ListResult(list.getItems());
        if (!StringUtils.hasText((String)result.getKind())) {
            result.setKind(list.getClass().getSimpleName());
        }
        this.setCommandResult(new CommandResult(result));
    }
}

