/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.kubernetes.command.AbstractClientCommand;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.command.WatchEventResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchCommand<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>, C extends KubernetesCommand<T, T>>
extends AbstractClientCommand<T, T, L, R, C> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Watch watch;
    private long timeout = 5000L;
    private final BlockingQueue<WatchEventResult<T>> results = new ArrayBlockingQueue<WatchEventResult<T>>(1);
    private WatchEventResult<T> cachedResult;

    public AbstractWatchCommand(String name) {
        super("watch-" + name);
    }

    @Override
    public void execute(MixedOperation<T, L, R> operation, TestContext context) {
        this.watch = operation.watch(new Watcher<T>(){

            public void eventReceived(Watcher.Action action, T resource) {
                if (AbstractWatchCommand.this.results.isEmpty() && AbstractWatchCommand.this.cachedResult == null) {
                    AbstractWatchCommand.this.results.add(new WatchEventResult(resource, action));
                } else {
                    AbstractWatchCommand.this.logger.debug("Ignoring watch result: " + action.name());
                }
            }

            public void onClose(WatcherException cause) {
                if (AbstractWatchCommand.this.results.isEmpty() && AbstractWatchCommand.this.cachedResult == null) {
                    AbstractWatchCommand.this.results.add(new WatchEventResult(cause));
                }
            }
        });
    }

    @Override
    public WatchEventResult<T> getCommandResult() {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        try {
            WatchEventResult<T> watchEventResult = this.results.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (watchEventResult == null) {
                throw new MessageTimeoutException(this.timeout, "watchEventResultQueue");
            }
            try {
                this.watch.close();
            }
            catch (KubernetesClientException e) {
                this.logger.warn("Failed to gracefully close watch", (Throwable)e);
            }
            watchEventResult.setWatch(this.watch);
            this.cachedResult = watchEventResult;
            return watchEventResult;
        }
        catch (InterruptedException e) {
            throw new CitrusRuntimeException("Failed to wait for watch result", (Throwable)e);
        }
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

