/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.endpoint;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.endpoint.KubernetesEndpointConfiguration;

public class KubernetesEndpointComponent
extends AbstractEndpointComponent {
    public KubernetesEndpointComponent() {
        super("k8s");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        KubernetesClient client = new KubernetesClient();
        if (resourcePath.startsWith("https://") || resourcePath.startsWith("http://")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setMasterUrl(resourcePath);
        } else {
            client.getEndpointConfiguration().getKubernetesClientConfig().setMasterUrl("https://" + resourcePath);
        }
        if (parameters.containsKey("version")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setApiVersion(parameters.remove("version"));
        }
        if (parameters.containsKey("username")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setUsername(parameters.remove("username"));
        }
        if (parameters.containsKey("password")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setPassword(parameters.remove("password"));
        }
        if (parameters.containsKey("namespace")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setNamespace(parameters.remove("namespace"));
        }
        if (parameters.containsKey("cert-file")) {
            client.getEndpointConfiguration().getKubernetesClientConfig().setCaCertFile(parameters.remove("cert-file"));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)client.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, KubernetesEndpointConfiguration.class), context);
        return client;
    }
}

