/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateAnnotationsAction;

@XmlRootElement(name="create-annotations")
public class CreateAnnotations
extends AbstractKubernetesAction.Builder<CreateAnnotationsAction, CreateAnnotations> {
    private final CreateAnnotationsAction.Builder delegate = new CreateAnnotationsAction.Builder();

    @XmlAttribute(required=true)
    public void setResource(String name) {
        this.delegate.resource(name);
    }

    @XmlAttribute(required=true)
    public void setType(String resourceType) {
        this.delegate.type(resourceType);
    }

    @XmlElement
    public void setAnnotations(Annotations annotations) {
        annotations.getAnnotations().forEach(annotation -> this.delegate.annotation(annotation.getName(), annotation.getValue()));
    }

    public CreateAnnotations description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateAnnotations actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateAnnotations client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateAnnotations inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateAnnotations autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateAnnotationsAction doBuild() {
        return (CreateAnnotationsAction)this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"annotations"})
    public static class Annotations {
        @XmlElement(name="annotation", required=true)
        protected List<Annotation> annotations;

        public List<Annotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<Annotation>();
            }
            return this.annotations;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Annotation {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

