/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateConfigMapAction;

@XmlRootElement(name="create-config-map")
public class CreateConfigMap
extends AbstractKubernetesAction.Builder<CreateConfigMapAction, CreateConfigMap> {
    private final CreateConfigMapAction.Builder delegate = new CreateConfigMapAction.Builder();

    @XmlAttribute(required=true)
    public void setName(String name) {
        this.delegate.configMap(name);
    }

    @XmlElement
    public void setProperties(Properties properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        properties.getProperties().forEach(property -> props.put(property.getName(), property.getValue()));
        this.delegate.properties(props);
    }

    @XmlAttribute
    public void setFile(String path) {
        this.delegate.fromFile(path);
    }

    public CreateConfigMap description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateConfigMap actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateConfigMap client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateConfigMap inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateConfigMap autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateConfigMapAction doBuild() {
        return (CreateConfigMapAction)this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"properties"})
    public static class Properties {
        @XmlElement(name="property", required=true)
        protected List<Property> properties;

        public List<Property> getProperties() {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>();
            }
            return this.properties;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Property {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

