/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateCustomResourceAction;

@XmlRootElement(name="create-custom-resource")
public class CreateCustomResource
extends AbstractKubernetesAction.Builder<CreateCustomResourceAction, CreateCustomResource> {
    private final CreateCustomResourceAction.Builder delegate = new CreateCustomResourceAction.Builder();

    @XmlElement
    public void setData(String content) {
        this.delegate.content(content);
    }

    @XmlAttribute
    public void setType(String resourceType) {
        try {
            this.delegate.resourceType(Class.forName(resourceType));
        }
        catch (ClassCastException | ClassNotFoundException e) {
            this.delegate.type(resourceType);
        }
    }

    @XmlAttribute
    public void setKind(String kind) {
        this.delegate.kind(kind);
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.delegate.group(group);
    }

    @XmlAttribute
    public void setVersion(String version) {
        this.delegate.version(version);
    }

    @XmlAttribute(name="api-version")
    public void setApiVersion(String apiVersion) {
        this.delegate.apiVersion(apiVersion);
    }

    @XmlAttribute
    public void setFile(String path) {
        this.delegate.file(path);
    }

    public CreateCustomResource description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateCustomResource actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateCustomResource client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateCustomResource inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateCustomResource autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateCustomResourceAction doBuild() {
        return (CreateCustomResourceAction)this.delegate.build();
    }
}

