/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateServiceAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

@XmlRootElement(name="create-service")
public class CreateService
extends AbstractKubernetesAction.Builder<CreateServiceAction, CreateService>
implements ReferenceResolverAware {
    private final CreateServiceAction.Builder delegate = new CreateServiceAction.Builder();

    @XmlAttribute(required=true)
    public void setName(String name) {
        this.delegate.service(name);
    }

    @XmlAttribute
    public void setServer(String serverName) {
        this.delegate.server(serverName);
    }

    @XmlAttribute(name="auto-create-server-binding")
    public void setAutoCreateServerBinding(boolean enabled) {
        this.delegate.autoCreateServerBinding(enabled);
    }

    @XmlElement
    public void setPorts(PortMappings portMappings) {
        portMappings.getPorts().forEach(mapping -> this.delegate.portMapping(mapping.getPort(), mapping.getTargetPort()));
    }

    @XmlAttribute
    public void setProtocol(String protocol) {
        this.delegate.protocol(protocol);
    }

    @XmlElement(required=true)
    public void setSelector(PodSelector selector) {
        selector.getSelector().forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    public CreateService description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateService actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateService client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateService inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateService autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.setReferenceResolver(referenceResolver);
    }

    @Override
    public CreateServiceAction doBuild() {
        return (CreateServiceAction)this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"ports"})
    public static class PortMappings {
        @XmlElement(name="port-mapping", required=true)
        protected List<PortMapping> ports;

        public List<PortMapping> getPorts() {
            if (this.ports == null) {
                this.ports = new ArrayList<PortMapping>();
            }
            return this.ports;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class PortMapping {
            @XmlAttribute(required=true)
            protected String port;
            @XmlAttribute(name="target-port")
            protected String targetPort;

            public void setPort(String port) {
                this.port = port;
            }

            public String getPort() {
                return this.port;
            }

            public void setTargetPort(String targetPort) {
                this.targetPort = targetPort;
            }

            public String getTargetPort() {
                return this.targetPort;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"selector"})
    public static class PodSelector {
        @XmlElement(name="label", required=true)
        protected List<Label> selector;

        public List<Label> getSelector() {
            if (this.selector == null) {
                this.selector = new ArrayList<Label>();
            }
            return this.selector;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Label {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

