/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.xml.CreateAnnotations;
import org.citrusframework.kubernetes.xml.CreateConfigMap;
import org.citrusframework.kubernetes.xml.CreateCustomResource;
import org.citrusframework.kubernetes.xml.CreateLabels;
import org.citrusframework.kubernetes.xml.CreateResource;
import org.citrusframework.kubernetes.xml.CreateSecret;
import org.citrusframework.kubernetes.xml.CreateService;
import org.citrusframework.kubernetes.xml.DeleteConfigMap;
import org.citrusframework.kubernetes.xml.DeleteCustomResource;
import org.citrusframework.kubernetes.xml.DeleteResource;
import org.citrusframework.kubernetes.xml.DeleteSecret;
import org.citrusframework.kubernetes.xml.DeleteService;
import org.citrusframework.kubernetes.xml.VerifyCustomResource;
import org.citrusframework.kubernetes.xml.VerifyPod;
import org.citrusframework.kubernetes.xml.WatchPodLogs;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

@XmlRootElement(name="kubernetes")
public class Kubernetes
implements TestActionBuilder<KubernetesAction>,
ReferenceResolverAware {
    private AbstractKubernetesAction.Builder<?, ?> builder;
    private String description;
    private String actor;
    private String kubernetesClient;
    private String namespace;
    private boolean autoRemoveResources = KubernetesSettings.isAutoRemoveResources();
    private ReferenceResolver referenceResolver;

    @XmlElement
    public Kubernetes setDescription(String value) {
        this.description = this.description;
        return this;
    }

    @XmlAttribute
    public Kubernetes setActor(String actor) {
        this.actor = actor;
        return this;
    }

    @XmlAttribute
    public Kubernetes setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @XmlAttribute(name="auto-remove")
    public Kubernetes setAutoRemove(boolean autoRemoveResources) {
        this.autoRemoveResources = autoRemoveResources;
        return this;
    }

    @XmlAttribute
    public Kubernetes setClient(String client) {
        this.kubernetesClient = client;
        return this;
    }

    @XmlElement(name="create-service")
    public void setCreateService(CreateService builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-secret")
    public void setCreateSecret(CreateSecret builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-config-map")
    public void setCreateConfigMap(CreateConfigMap builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-resource")
    public void setCreateResource(CreateResource builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-custom-resource")
    public void setCreateCustomResource(CreateCustomResource builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-labels")
    public void setCreateLabels(CreateLabels builder) {
        this.builder = builder;
    }

    @XmlElement(name="create-annotations")
    public void setCreateAnnotations(CreateAnnotations builder) {
        this.builder = builder;
    }

    @XmlElement(name="delete-service")
    public void setDeleteService(DeleteService builder) {
        this.builder = builder;
    }

    @XmlElement(name="delete-secret")
    public void setDeleteSecret(DeleteSecret builder) {
        this.builder = builder;
    }

    @XmlElement(name="delete-config-map")
    public void setDeleteConfigMap(DeleteConfigMap builder) {
        this.builder = builder;
    }

    @XmlElement(name="delete-resource")
    public void setDeleteResource(DeleteResource builder) {
        this.builder = builder;
    }

    @XmlElement(name="delete-custom-resource")
    public void setDeleteCustomResource(DeleteCustomResource builder) {
        this.builder = builder;
    }

    @XmlElement(name="verify-pod")
    public void setVerifyPod(VerifyPod builder) {
        this.builder = builder;
    }

    @XmlElement(name="verify-custom-resource")
    public void setVerifyCustomResource(VerifyCustomResource builder) {
        this.builder = builder;
    }

    @XmlElement(name="watch-pod-logs")
    public void setWatchPodLogs(WatchPodLogs builder) {
        this.builder = builder;
    }

    public KubernetesAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing Kubernetes action - please provide proper action details");
        }
        if (this.builder instanceof TestActionContainerBuilder) {
            ((TestActionContainerBuilder)this.builder).getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        }
        if (this.builder instanceof ReferenceResolverAware) {
            this.builder.setReferenceResolver(this.referenceResolver);
        }
        this.builder.description(this.description);
        this.builder.inNamespace(this.namespace);
        this.builder.autoRemoveResources(this.autoRemoveResources);
        if (this.referenceResolver != null) {
            if (this.kubernetesClient != null) {
                this.builder.client((KubernetesClient)this.referenceResolver.resolve(this.kubernetesClient, KubernetesClient.class));
            }
            if (this.actor != null) {
                this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
            }
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

