/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.VerifyPodAction;

@XmlRootElement(name="verify-pod")
public class VerifyPod
extends AbstractKubernetesAction.Builder<VerifyPodAction, VerifyPod> {
    private final VerifyPodAction.Builder delegate = new VerifyPodAction.Builder();

    @XmlAttribute
    public void setName(String name) {
        this.delegate.podName(name);
    }

    @XmlElement
    public void setLabels(Labels labels) {
        labels.getLabels().forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    @XmlAttribute
    public void setLabel(String labelExpression) {
        String[] tokens = labelExpression.split("=", 2);
        this.delegate.label(tokens[0].trim(), tokens[1].trim());
    }

    @XmlAttribute
    public void setPhase(String phase) {
        this.delegate.phase(phase);
    }

    @XmlAttribute(name="log-message")
    public void setLogMessage(String message) {
        this.delegate.waitForLogMessage(message);
    }

    @XmlAttribute(name="print-logs")
    public void setPrintLogs(boolean printLogs) {
        this.delegate.printLogs(printLogs);
    }

    @XmlAttribute(name="max-attempts")
    public void setMaxAttempts(int maxAttempts) {
        this.delegate.maxAttempts(maxAttempts);
    }

    @XmlAttribute(name="delay-between-attempts")
    public void setDelayBetweenAttempts(long delayBetweenAttempts) {
        this.delegate.delayBetweenAttempts(delayBetweenAttempts);
    }

    public VerifyPod description(String description) {
        this.delegate.description(description);
        return this;
    }

    public VerifyPod actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public VerifyPod client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public VerifyPod inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public VerifyPod autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public VerifyPodAction doBuild() {
        return (VerifyPodAction)this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"labels"})
    public static class Labels {
        @XmlElement(name="label", required=true)
        protected List<Label> labels;

        public List<Label> getLabels() {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            return this.labels;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Label {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

