/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.client;

import java.util.Properties;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.mail.client.MailClient;
import org.citrusframework.mail.message.MailMessageConverter;
import org.citrusframework.mail.model.MailMarshaller;

public class MailClientBuilder
extends AbstractEndpointBuilder<MailClient> {
    private final MailClient endpoint = new MailClient();

    protected MailClient getEndpoint() {
        return this.endpoint;
    }

    public MailClientBuilder host(String host) {
        this.endpoint.getEndpointConfiguration().setHost(host);
        return this;
    }

    public MailClientBuilder port(int port) {
        this.endpoint.getEndpointConfiguration().setPort(port);
        return this;
    }

    public MailClientBuilder protocol(String protocol) {
        this.endpoint.getEndpointConfiguration().setProtocol(protocol);
        return this;
    }

    public MailClientBuilder username(String username) {
        this.endpoint.getEndpointConfiguration().setUsername(username);
        return this;
    }

    public MailClientBuilder password(String password) {
        this.endpoint.getEndpointConfiguration().setPassword(password);
        return this;
    }

    public MailClientBuilder javaMailProperties(Properties javaMailProperties) {
        this.endpoint.getEndpointConfiguration().setJavaMailProperties(javaMailProperties);
        return this;
    }

    public MailClientBuilder marshaller(MailMarshaller marshaller) {
        this.endpoint.getEndpointConfiguration().setMarshaller(marshaller);
        return this;
    }

    public MailClientBuilder messageConverter(MailMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public MailClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

