/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.config.annotation;

import java.util.Properties;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.mail.client.MailClient;
import org.citrusframework.mail.client.MailClientBuilder;
import org.citrusframework.mail.config.annotation.MailClientConfig;
import org.citrusframework.mail.message.MailMessageConverter;
import org.citrusframework.mail.model.MailMarshaller;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class MailClientConfigParser
implements AnnotationConfigParser<MailClientConfig, MailClient> {
    public MailClient parse(MailClientConfig annotation, ReferenceResolver referenceResolver) {
        MailClientBuilder builder = new MailClientBuilder();
        builder.host(annotation.host());
        builder.port(annotation.port());
        builder.protocol(annotation.protocol());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.javaMailProperties())) {
            builder.javaMailProperties((Properties)referenceResolver.resolve(annotation.javaMailProperties(), Properties.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((MailMessageConverter)referenceResolver.resolve(annotation.messageConverter(), MailMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.marshaller())) {
            builder.marshaller((MailMarshaller)referenceResolver.resolve(annotation.marshaller(), MailMarshaller.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (MailClient)builder.initialize().build();
    }
}

