/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.client;

import jakarta.mail.Authenticator;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.mail.client.MailEndpointConfiguration;
import org.citrusframework.mail.client.MailSender;
import org.citrusframework.message.Message;
import org.citrusframework.message.RawMessage;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.Producer;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMailMessage;

public class MailClient
extends AbstractEndpoint
implements Producer,
InitializingPhase {
    private static final Logger logger = LoggerFactory.getLogger(MailClient.class);
    private MailSender mailSender = new MailSender();

    public MailClient() {
        super((EndpointConfiguration)new MailEndpointConfiguration());
    }

    public MailClient(MailEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public MailEndpointConfiguration getEndpointConfiguration() {
        return (MailEndpointConfiguration)super.getEndpointConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, TestContext context) {
        Message mailMessage;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Sending mail message to host: '%s://%s:%s'", this.getEndpointConfiguration().getProtocol(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
        }
        MimeMailMessage mimeMessage = this.getEndpointConfiguration().getMessageConverter().convertOutbound(message, this.getEndpointConfiguration(), context);
        try {
            this.mailSender.send(mimeMessage.getMimeMessage());
        }
        catch (MessagingException e) {
            throw new CitrusRuntimeException("Failed to send mail message!", (Throwable)e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            mimeMessage.getMimeMessage().writeTo((OutputStream)bos);
            mailMessage = new RawMessage(bos.toString());
        }
        catch (MessagingException | IOException e) {
            mailMessage = message;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close output stream", (Throwable)e);
            }
        }
        context.onOutboundMessage(mailMessage);
        logger.info(String.format("Mail message was sent to host: '%s://%s:%s'", this.getEndpointConfiguration().getProtocol(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
    }

    public Producer createProducer() {
        return this;
    }

    public Consumer createConsumer() {
        throw new CitrusRuntimeException("Mail client is unable to create message consumer!");
    }

    public void initialize() {
        if (!StringUtils.hasText((String)this.getEndpointConfiguration().getProtocol())) {
            throw new CitrusRuntimeException("A mailing protocol must be configured!");
        }
        if (StringUtils.hasText((String)this.getEndpointConfiguration().getUsername()) || StringUtils.hasText((String)this.getEndpointConfiguration().getPassword())) {
            this.getEndpointConfiguration().getJavaMailProperties().setProperty("mail." + this.getEndpointConfiguration().getProtocol() + ".auth", "true");
            this.getEndpointConfiguration().setAuthenticator(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailClient.this.getEndpointConfiguration().getUsername(), MailClient.this.getEndpointConfiguration().getPassword());
                }
            });
        }
        if (StringUtils.hasText((String)this.getEndpointConfiguration().getHost())) {
            this.getEndpointConfiguration().getJavaMailProperties().setProperty("mail." + this.getEndpointConfiguration().getProtocol() + ".host", this.getEndpointConfiguration().getHost());
        }
        if (this.getEndpointConfiguration().getPort() > 0) {
            this.getEndpointConfiguration().getJavaMailProperties().setProperty("mail." + this.getEndpointConfiguration().getProtocol() + ".port", String.valueOf(this.getEndpointConfiguration().getPort()));
        }
    }

    void setMailSender(MailSender mailSenderMock) {
        this.mailSender = mailSenderMock;
    }
}

