/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.citrusframework.TestClass;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.CitrusAppConfiguration;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitrusAppOptions<T extends CitrusAppConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(CitrusAppOptions.class);
    protected final List<CliOption<T>> options = new ArrayList<CliOption<T>>();

    protected CitrusAppOptions() {
        this.options.add(new CliOption<T>("h", "help", "Displays cli option usage"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator()).append("Citrus application option usage:").append(System.lineSeparator());
                for (CliOption option : CitrusAppOptions.this.options) {
                    builder.append(option.getInformation()).append(System.lineSeparator());
                }
                logger.info(builder.toString());
                ((CitrusAppConfiguration)((Object)configuration)).setTimeToLive(1000L);
                ((CitrusAppConfiguration)((Object)configuration)).setSkipTests(true);
            }
        });
        this.options.add(new CliOption<T>("d", "duration", "Maximum time in milliseconds the server should be up and running - server will terminate automatically when time exceeds"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (value == null || value.length() <= 0) {
                    throw new CitrusRuntimeException("Missing parameter value for -d/--duration option");
                }
                ((CitrusAppConfiguration)((Object)configuration)).setTimeToLive(Long.parseLong(value));
            }
        });
        this.options.add(new CliOption<T>("c", "config", "Custom configuration class"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (StringUtils.hasText((String)value)) {
                    try {
                        Class.forName(value);
                    }
                    catch (ClassNotFoundException e) {
                        throw new CitrusRuntimeException("Unable to access config class type: " + value, (Throwable)e);
                    }
                } else {
                    throw new CitrusRuntimeException("Missing parameter value for -c/--config option");
                }
                ((CitrusAppConfiguration)((Object)configuration)).setConfigClass(value);
            }
        });
        this.options.add(new CliOption<T>("s", "skipTests", "Skip test execution"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -s/--skipTests option");
                }
                ((CitrusAppConfiguration)((Object)configuration)).setSkipTests(Boolean.parseBoolean(value));
            }
        });
        this.options.add(new CliOption<T>("p", "package", "Test package to execute"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -p/--package option");
                }
                configuration.getPackages().add(value);
            }
        });
        this.options.add(new CliOption<T>("D", "properties", "Default system properties to set"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -D/--properties option");
                }
                configuration.getDefaultProperties().putAll(Arrays.stream(value.split(",")).map(keyValue -> keyValue.split("=")).filter(keyValue -> StringUtils.hasText((String)keyValue[0])).map(keyValue -> {
                    if (((String[])keyValue).length < 2) {
                        return new String[]{keyValue[0], ""};
                    }
                    return keyValue;
                }).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1])));
            }
        });
        this.options.add(new CliOption<T>("", "exit", "Force system exit when finished"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -e/--exit option");
                }
                ((CitrusAppConfiguration)((Object)configuration)).setSystemExit(Boolean.parseBoolean(value));
            }
        });
        this.options.add(new CliOption<T>("e", "engine", "Set test engine name used to run the tests"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -e/--exit option");
                }
                configuration.setEngine(value);
            }
        });
        this.options.add(new CliOption<T>("t", "test", "Test class/method to execute"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -t/--test option");
                }
                Object source = FileUtils.getFileExtension((String)value).isEmpty() ? TestClass.fromString((String)value) : FileUtils.getTestSource((String)value);
                configuration.getTestSources().add(source);
            }
        });
        this.options.add(new CliOption<T>("j", "jar", "External test jar to load tests from"){

            @Override
            protected void doProcess(T configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -j/--jar option");
                }
                configuration.setTestJar(new File(value));
            }
        });
    }

    public T apply(String[] arguments) {
        return (T)((Object)this.apply(new CitrusAppConfiguration(), arguments));
    }

    public T apply(T configuration, String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        CitrusAppOptions<T> options = new CitrusAppOptions<T>();
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            for (CliOption<T> option : options.options) {
                if (option.processOption(configuration, arg, args)) break;
            }
        }
        return configuration;
    }

    public static abstract class CliOption<T extends CitrusAppConfiguration> {
        private final String shortName;
        private final String fullName;
        private final String description;

        protected CliOption(String shortName, String fullName, String description) {
            this.shortName = "-" + shortName;
            this.fullName = "--" + fullName;
            this.description = description;
        }

        public boolean processOption(T configuration, String arg, LinkedList<String> remainingArgs) {
            if (arg.equals(this.shortName) || this.fullName.startsWith(arg)) {
                if (remainingArgs.isEmpty()) {
                    this.doProcess(configuration, arg, null, remainingArgs);
                } else {
                    this.doProcess(configuration, arg, remainingArgs.removeFirst(), remainingArgs);
                }
                return true;
            }
            return false;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            if (this.getShortName().equals("-")) {
                return "  " + this.getFullName() + " = " + this.getDescription();
            }
            return "  " + this.getShortName() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(T var1, String var2, String var3, LinkedList<String> var4);
    }
}

