/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.openapi.OpenApiSupport;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public final class OpenApiResourceLoader {
    private static final RawResolver RAW_RESOLVER = new RawResolver();
    private static final OasResolver OAS_RESOLVER = new OasResolver();

    private OpenApiResourceLoader() {
    }

    public static OasDocument fromFile(String resource) {
        return OpenApiResourceLoader.fromFile(FileUtils.getFileResource((String)resource), OAS_RESOLVER);
    }

    public static OasDocument fromString(String openApi) {
        return OpenApiResourceLoader.resolve(openApi, OAS_RESOLVER);
    }

    public static String rawFromFile(String resource) {
        return OpenApiResourceLoader.fromFile(FileUtils.getFileResource((String)resource), RAW_RESOLVER);
    }

    public static String rawFromString(String openApi) {
        return OpenApiResourceLoader.resolve(openApi, RAW_RESOLVER);
    }

    public static OasDocument fromFile(Resource resource) {
        return OpenApiResourceLoader.fromFile(resource, OAS_RESOLVER);
    }

    public static String rawFromFile(Resource resource) {
        return OpenApiResourceLoader.fromFile(resource, RAW_RESOLVER);
    }

    private static <T> T fromFile(Resource resource, Resolver<T> resolver) {
        try {
            return OpenApiResourceLoader.resolve(FileUtils.readToString((Resource)resource), resolver);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse Open API specification: " + resource, e);
        }
    }

    public static OasDocument fromWebResource(URL url) {
        return OpenApiResourceLoader.fromWebResource(url, OAS_RESOLVER);
    }

    public static String rawFromWebResource(URL url) {
        return OpenApiResourceLoader.fromWebResource(url, RAW_RESOLVER);
    }

    private static <T> T fromWebResource(URL url, Resolver<T> resolver) {
        URLConnection connection = null;
        try {
            T t;
            block14: {
                connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                    httpURLConnection.setRequestMethod(Method.GET.name());
                    connection.setRequestProperty("Accept", "application/json");
                    int status = httpURLConnection.getResponseCode();
                    if (status > 299) {
                        throw new IllegalStateException("Failed to retrieve Open API specification: " + url, new IOException(FileUtils.readToString((InputStream)httpURLConnection.getErrorStream())));
                    }
                }
                InputStream inputStream = connection.getInputStream();
                try {
                    t = OpenApiResourceLoader.resolve(FileUtils.readToString((InputStream)inputStream), resolver);
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to retrieve Open API specification: " + url, e);
                    }
                }
                inputStream.close();
            }
            return t;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                httpURLConnection.disconnect();
            }
        }
    }

    public static OasDocument fromSecuredWebResource(URL url) {
        return OpenApiResourceLoader.fromSecuredWebResource(url, OAS_RESOLVER);
    }

    public static String rawFromSecuredWebResource(URL url) {
        return OpenApiResourceLoader.fromSecuredWebResource(url, RAW_RESOLVER);
    }

    private static <T> T fromSecuredWebResource(URL url, Resolver<T> resolver) {
        Objects.requireNonNull(url);
        HttpURLConnection connection = null;
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod(Method.GET.name());
            connection.setRequestProperty("Accept", "application/json");
            int status = connection.getResponseCode();
            if (status > 299) {
                throw new IllegalStateException("Failed to retrieve Open API specification: " + url, new IOException(FileUtils.readToString((InputStream)connection.getErrorStream())));
            }
            T t = OpenApiResourceLoader.resolve(FileUtils.readToString((InputStream)connection.getInputStream()), resolver);
            return t;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create https client for ssl connection", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to retrieve Open API specification: " + url, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static <T> T resolve(String openApi, Resolver<T> resolver) {
        if (OpenApiResourceLoader.isJsonSpec(openApi)) {
            return resolver.resolveFromString(openApi);
        }
        JsonNode node = (JsonNode)OpenApiSupport.json().convertValue(OpenApiSupport.yaml().load(openApi), JsonNode.class);
        return resolver.resolveFromNode(node);
    }

    private static boolean isJsonSpec(String specification) {
        return specification.trim().startsWith("{");
    }

    private static class OasResolver
    implements Resolver<OasDocument> {
        private OasResolver() {
        }

        @Override
        public OasDocument resolveFromString(String specification) {
            return (OasDocument)Library.readDocumentFromJSONString((String)specification);
        }

        @Override
        public OasDocument resolveFromNode(JsonNode node) {
            return (OasDocument)Library.readDocument((Object)node);
        }
    }

    private static interface Resolver<T> {
        public T resolveFromString(String var1);

        public T resolveFromNode(JsonNode var1);
    }

    private static class RawResolver
    implements Resolver<String> {
        private static final ObjectMapper mapper = new ObjectMapper();

        private RawResolver() {
        }

        @Override
        public String resolveFromString(String specification) {
            return specification;
        }

        @Override
        public String resolveFromNode(JsonNode node) {
            try {
                return mapper.writeValueAsString((Object)node);
            }
            catch (JsonProcessingException e) {
                throw new CitrusRuntimeException("Unable to write OpenApi specification node to string!", (Throwable)e);
            }
        }
    }
}

