/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import io.apicurio.datamodels.openapi.models.OasSchema;
import org.citrusframework.context.TestContext;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.random.RandomContext;

public final class OpenApiTestDataGenerator {
    private OpenApiTestDataGenerator() {
    }

    public static String createOutboundPayload(OasSchema schema, OpenApiSpecification specification) {
        RandomContext randomContext = new RandomContext(specification, true);
        randomContext.generate(schema);
        return randomContext.getRandomModelBuilder().writeToJson();
    }

    public static String createRandomValueExpression(String name, OasSchema schema, OpenApiSpecification specification, TestContext context) {
        if (context.getVariables().containsKey(name)) {
            return "${" + name + "}";
        }
        RandomContext randomContext = new RandomContext(specification, false);
        randomContext.generate(schema);
        return randomContext.getRandomModelBuilder().writeToJson();
    }

    public static String createRandomValueExpression(String name, OasSchema schema, TestContext context) {
        if (context.getVariables().containsKey(name)) {
            return "${" + name + "}";
        }
        return OpenApiTestDataGenerator.createRandomValueExpression(schema);
    }

    public static String createRandomValueExpression(OasSchema schema) {
        RandomContext randomContext = new RandomContext();
        randomContext.generate(schema);
        return randomContext.getRandomModelBuilder().writeToJson();
    }
}

