/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;
import org.springframework.util.CollectionUtils;

public class RandomCompositeGenerator
extends RandomGenerator {
    private static void createOneOf(RandomContext randomContext, List<OasSchema> schemas) {
        int schemaIndex = ThreadLocalRandom.current().nextInt(schemas.size());
        randomContext.getRandomModelBuilder().object(() -> randomContext.generate((OasSchema)schemas.get(schemaIndex)));
    }

    private static void createAnyOf(RandomContext randomContext, Oas30Schema schema) {
        randomContext.getRandomModelBuilder().object(() -> {
            boolean anyAdded = false;
            for (OasSchema oneSchema : schema.anyOf) {
                if (!ThreadLocalRandom.current().nextBoolean()) continue;
                randomContext.generate(oneSchema);
                anyAdded = true;
            }
            if (!anyAdded) {
                RandomCompositeGenerator.createOneOf(randomContext, schema.anyOf);
            }
        });
    }

    private static Map<String, Object> createAllOf(RandomContext randomContext, OasSchema schema) {
        HashMap<String, Object> allOf = new HashMap<String, Object>();
        randomContext.getRandomModelBuilder().object(() -> {
            for (OasSchema oneSchema : schema.allOf) {
                randomContext.generate(oneSchema);
            }
        });
        return allOf;
    }

    @Override
    public boolean handles(OasSchema other) {
        return OasModelHelper.isCompositeSchema(other);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema schema) {
        if (!CollectionUtils.isEmpty((Collection)schema.allOf)) {
            RandomCompositeGenerator.createAllOf(randomContext, schema);
            return;
        }
        if (schema instanceof Oas30Schema) {
            Oas30Schema oas30Schema = (Oas30Schema)schema;
            if (!CollectionUtils.isEmpty((Collection)oas30Schema.anyOf)) {
                RandomCompositeGenerator.createAnyOf(randomContext, oas30Schema);
                return;
            }
        }
        if (!(schema instanceof Oas30Schema)) return;
        Oas30Schema oas30Schema = (Oas30Schema)schema;
        if (CollectionUtils.isEmpty((Collection)oas30Schema.oneOf)) return;
        RandomCompositeGenerator.createOneOf(randomContext, oas30Schema.oneOf);
    }
}

