/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import java.math.BigDecimal;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;
import org.citrusframework.openapi.util.OpenApiUtils;

public class RandomNumberGenerator
extends RandomGenerator {
    public static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);
    public static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    public static final BigDecimal MINUS_THOUSAND = BigDecimal.valueOf(-1000L);

    private static BigDecimal[] determineBounds(OasSchema schema) {
        BigDecimal bdMaximum;
        BigDecimal bdMinimum;
        Number maximum = schema.maximum;
        Number minimum = schema.minimum;
        Number multipleOf = schema.multipleOf;
        if (minimum == null && maximum == null) {
            bdMinimum = MINUS_THOUSAND;
            bdMaximum = THOUSAND;
        } else if (minimum == null) {
            bdMaximum = new BigDecimal(maximum.toString());
            bdMinimum = RandomNumberGenerator.calculateMinRelativeToMax(bdMaximum, multipleOf);
        } else if (maximum == null) {
            bdMinimum = new BigDecimal(minimum.toString());
            bdMaximum = RandomNumberGenerator.calculateMaxRelativeToMin(bdMinimum, multipleOf);
        } else {
            bdMinimum = new BigDecimal(minimum.toString());
            bdMaximum = new BigDecimal(maximum.toString());
        }
        return new BigDecimal[]{bdMinimum, bdMaximum};
    }

    static BigDecimal calculateMinRelativeToMax(BigDecimal max, Number multipleOf) {
        if (multipleOf != null) {
            return max.subtract(new BigDecimal(multipleOf.toString()).abs().multiply(HUNDRED));
        }
        return max.subtract(max.multiply(BigDecimal.valueOf(2L)).max(THOUSAND));
    }

    static BigDecimal calculateMaxRelativeToMin(BigDecimal min, Number multipleOf) {
        if (multipleOf != null) {
            return min.add(new BigDecimal(multipleOf.toString()).abs().multiply(HUNDRED));
        }
        return min.add(min.multiply(BigDecimal.valueOf(2L)).max(THOUSAND));
    }

    @Override
    public boolean handles(OasSchema other) {
        return OpenApiUtils.isAnyNumberScheme(other);
    }

    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema schema) {
        boolean exclusiveMaximum = Boolean.TRUE.equals(schema.exclusiveMaximum);
        boolean exclusiveMinimum = Boolean.TRUE.equals(schema.exclusiveMinimum);
        BigDecimal[] bounds = RandomNumberGenerator.determineBounds(schema);
        BigDecimal minimum = bounds[0];
        BigDecimal maximum = bounds[1];
        if (schema.multipleOf != null) {
            randomContext.getRandomModelBuilder().appendSimple(String.format("citrus:randomNumberGenerator('%d', '%s', '%s', '%s', '%s', '%s')", this.determineDecimalPlaces(schema, minimum, maximum), minimum, maximum, exclusiveMinimum, exclusiveMaximum, schema.multipleOf));
        } else {
            randomContext.getRandomModelBuilder().appendSimple(String.format("citrus:randomNumberGenerator('%d', '%s', '%s', '%s', '%s')", this.determineDecimalPlaces(schema, minimum, maximum), minimum, maximum, exclusiveMinimum, exclusiveMaximum));
        }
    }

    private int determineDecimalPlaces(OasSchema schema, BigDecimal minimum, BigDecimal maximum) {
        if ("integer".equals(schema.type)) {
            return 0;
        }
        Number multipleOf = schema.multipleOf;
        if (multipleOf != null) {
            return this.findLeastSignificantDecimalPlace(new BigDecimal(multipleOf.toString()));
        }
        return Math.max(2, Math.max(this.findLeastSignificantDecimalPlace(minimum), this.findLeastSignificantDecimalPlace(maximum)));
    }

    int findLeastSignificantDecimalPlace(BigDecimal number) {
        String[] parts = (number = number.stripTrailingZeros()).toPlainString().split("\\.");
        if (parts.length == 1) {
            return 0;
        }
        return parts[1].length();
    }
}

