/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;

public class RandomStringGenerator
extends RandomGenerator {
    private static final OasSchema STRING_SCHEMA = new Oas30Schema();

    public RandomStringGenerator() {
        super(STRING_SCHEMA);
    }

    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema schema) {
        int min = 1;
        int max = 10;
        if (schema.minLength != null && schema.minLength.intValue() > 0) {
            min = schema.minLength.intValue();
        }
        if (schema.maxLength != null && schema.maxLength.intValue() > 0) {
            max = schema.maxLength.intValue();
        }
        randomContext.getRandomModelBuilder().appendSimpleQuoted("citrus:randomString(%s,MIXED,true,%s)".formatted(max, min));
    }

    static {
        RandomStringGenerator.STRING_SCHEMA.type = "string";
    }
}

