/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.validation.context.DefaultMessageValidationContext;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.citrusframework.validation.context.ValidationContext;

public class OpenApiMessageValidationContext
extends DefaultMessageValidationContext
implements SchemaValidationContext {
    private final boolean schemaValidation;
    private final String openApiSpecificationId;
    private final String operationKey;

    public OpenApiMessageValidationContext(Builder builder) {
        this.schemaValidation = builder.schemaValidation != null ? builder.schemaValidation : builder.openApiSpecification.isApiRequestValidationEnabled() || builder.openApiSpecification.isApiResponseValidationEnabled();
        this.openApiSpecificationId = builder.openApiSpecificationId;
        this.operationKey = builder.operationKey;
    }

    public boolean requiresValidator() {
        return true;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidation;
    }

    public String getSchemaRepository() {
        return this.openApiSpecificationId;
    }

    public String getSchema() {
        return this.operationKey;
    }

    public static final class Builder
    implements ValidationContext.Builder<OpenApiMessageValidationContext, Builder>,
    SchemaValidationContext.Builder<Builder> {
        private OpenApiSpecification openApiSpecification;
        private String openApiSpecificationId;
        private String operationKey;
        private Boolean schemaValidation = OpenApiSettings.isRequestValidationEnabled();

        public static Builder openApi(OpenApiSpecification openApiSpecification) {
            Builder builder = new Builder();
            builder.openApiSpecification = openApiSpecification;
            return builder;
        }

        public static Builder openApi() {
            return new Builder();
        }

        public Builder schemaValidation(boolean enabled) {
            this.schemaValidation = enabled;
            return this;
        }

        public Builder schema(String schemaName) {
            this.operationKey = schemaName;
            return this;
        }

        public Builder schemaRepository(String schemaRepository) {
            this.openApiSpecificationId = schemaRepository;
            return this;
        }

        public OpenApiMessageValidationContext build() {
            return new OpenApiMessageValidationContext(this);
        }
    }
}

