/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import com.google.common.annotations.VisibleForTesting;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.validation.OpenApiValidationPolicy;
import org.citrusframework.util.EnvUtils;
import org.citrusframework.util.SystemProvider;

public class OpenApiSettings {
    public static final String GENERATE_OPTIONAL_FIELDS_ENABLED_PROPERTY = "citrus.openapi.generate.optional.fields";
    public static final String GENERATE_OPTIONAL_FIELDS_ENABLED_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.generate.optional.fields");
    public static final String REQUEST_VALIDATION_ENABLED_PROPERTY = "citrus.openapi.validation.enabled.request";
    public static final String REQUEST_VALIDATION_ENABLED_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.validation.enabled.request");
    public static final String RESPONSE_VALIDATION_ENABLED_PROPERTY = "citrus.openapi.validation.enabled.response";
    public static final String RESPONSE_VALIDATION_ENABLED_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.validation.enabled.response");
    public static final String NEGLECT_OPEN_API_BASE_PATH_ENABLED_PROPERTY = "citrus.openapi.neglect.base.path";
    public static final String NEGLECT_OPEN_API_BASE_PATH_ENABLED_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.neglect.base.path");
    public static final String REQUEST_AUTO_FILL_RANDOM_VALUES_PROPERTY = "citrus.openapi.request.fill.random.values";
    public static final String REQUEST_AUTO_FILL_RANDOM_VALUES_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.request.fill.random.values");
    public static final String RESPONSE_AUTO_FILL_RANDOM_VALUES_PROPERTY = "citrus.openapi.response.fill.random.values";
    public static final String RESPONSE_AUTO_FILL_RANDOM_VALUES_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.response.fill.random.values");
    public static final String OPEN_API_VALIDATION_POLICY_PROPERTY = "citrus.openapi.validation.policy";
    public static final String OPEN_API_VALIDATION_POLICY_ENV = EnvUtils.transformPropertyToEnv((String)"citrus.openapi.validation.policy");

    private OpenApiSettings() {
    }

    public static boolean isGenerateOptionalFieldsEnabled() {
        return OpenApiSettings.isGenerateOptionalFieldsEnabled(SystemProvider.SYSTEM_PROVIDER);
    }

    @VisibleForTesting
    static boolean isGenerateOptionalFieldsEnabled(SystemProvider systemProvider) {
        return EnvUtils.booleanPropertyOrDefault((SystemProvider)systemProvider, (String)GENERATE_OPTIONAL_FIELDS_ENABLED_PROPERTY, (String)GENERATE_OPTIONAL_FIELDS_ENABLED_ENV, (boolean)true);
    }

    public static boolean isRequestValidationEnabled() {
        return OpenApiSettings.isRequestValidationEnabled(SystemProvider.SYSTEM_PROVIDER);
    }

    @VisibleForTesting
    static boolean isRequestValidationEnabled(SystemProvider systemProvider) {
        return EnvUtils.booleanPropertyOrDefault((SystemProvider)systemProvider, (String)REQUEST_VALIDATION_ENABLED_PROPERTY, (String)REQUEST_VALIDATION_ENABLED_ENV, (boolean)true);
    }

    public static boolean isResponseValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty(RESPONSE_VALIDATION_ENABLED_PROPERTY, System.getenv(RESPONSE_VALIDATION_ENABLED_ENV) != null ? System.getenv(RESPONSE_VALIDATION_ENABLED_ENV) : "true"));
    }

    @VisibleForTesting
    static boolean isResponseValidationEnabled(SystemProvider systemProvider) {
        return EnvUtils.booleanPropertyOrDefault((SystemProvider)systemProvider, (String)RESPONSE_VALIDATION_ENABLED_PROPERTY, (String)RESPONSE_VALIDATION_ENABLED_ENV, (boolean)true);
    }

    public static boolean isNeglectBasePathEnabled() {
        return Boolean.parseBoolean(System.getProperty(NEGLECT_OPEN_API_BASE_PATH_ENABLED_PROPERTY, System.getenv(NEGLECT_OPEN_API_BASE_PATH_ENABLED_ENV) != null ? System.getenv(NEGLECT_OPEN_API_BASE_PATH_ENABLED_ENV) : "false"));
    }

    @VisibleForTesting
    static boolean isNeglectBasePathEnabled(SystemProvider systemProvider) {
        return EnvUtils.booleanPropertyOrDefault((SystemProvider)systemProvider, (String)NEGLECT_OPEN_API_BASE_PATH_ENABLED_PROPERTY, (String)NEGLECT_OPEN_API_BASE_PATH_ENABLED_ENV, (boolean)false);
    }

    public static AutoFillType getRequestAutoFillRandomValues() {
        return OpenApiSettings.getRequestAutoFillRandomValues(SystemProvider.SYSTEM_PROVIDER);
    }

    @VisibleForTesting
    static AutoFillType getRequestAutoFillRandomValues(SystemProvider systemProvider) {
        return (AutoFillType)EnvUtils.enumPropertyOrDefault((SystemProvider)systemProvider, AutoFillType.class, (String)REQUEST_AUTO_FILL_RANDOM_VALUES_PROPERTY, (String)REQUEST_AUTO_FILL_RANDOM_VALUES_ENV, (Enum)AutoFillType.REQUIRED);
    }

    public static AutoFillType getResponseAutoFillRandomValues() {
        return OpenApiSettings.getResponseAutoFillRandomValues(SystemProvider.SYSTEM_PROVIDER);
    }

    @VisibleForTesting
    static AutoFillType getResponseAutoFillRandomValues(SystemProvider systemProvider) {
        return (AutoFillType)EnvUtils.enumPropertyOrDefault((SystemProvider)systemProvider, AutoFillType.class, (String)RESPONSE_AUTO_FILL_RANDOM_VALUES_PROPERTY, (String)RESPONSE_AUTO_FILL_RANDOM_VALUES_ENV, (Enum)AutoFillType.REQUIRED);
    }

    public static OpenApiValidationPolicy getOpenApiValidationPolicy() {
        return OpenApiSettings.getOpenApiValidationPolicy(SystemProvider.SYSTEM_PROVIDER);
    }

    @VisibleForTesting
    static OpenApiValidationPolicy getOpenApiValidationPolicy(SystemProvider systemProvider) {
        return (OpenApiValidationPolicy)EnvUtils.enumPropertyOrDefault((SystemProvider)systemProvider, OpenApiValidationPolicy.class, (String)OPEN_API_VALIDATION_POLICY_PROPERTY, (String)OPEN_API_VALIDATION_POLICY_ENV, (Enum)OpenApiValidationPolicy.REPORT);
    }
}

