/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.OpenApiResourceLoader;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.Specification;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.util.OpenApiUtils;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.citrusframework.openapi.validation.OpenApiValidationContextLoader;
import org.citrusframework.openapi.validation.OpenApiValidationPolicy;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiSpecification
implements Specification {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiSpecification.class);
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private String uid;
    private final Set<String> aliases = Collections.synchronizedSet(new HashSet());
    private final Map<String, OperationPathAdapter> operationKeyToOperationPathAdapter = new ConcurrentHashMap<String, OperationPathAdapter>();
    private final Map<OasOperation, String> operationToUniqueId = new ConcurrentHashMap<OasOperation, String>();
    private String specUrl;
    private String httpClient;
    private String requestUrl;
    private boolean neglectBasePath = OpenApiSettings.isNeglectBasePathEnabled();
    private String rootContextPath;
    private OasDocument openApiDoc;
    private OpenApiValidationContext openApiValidationContext;
    private boolean generateOptionalFields = OpenApiSettings.isGenerateOptionalFieldsEnabled();
    private AutoFillType requestAutoFill = OpenApiSettings.getRequestAutoFillRandomValues();
    private AutoFillType responseAutoFill = OpenApiSettings.getResponseAutoFillRandomValues();
    private boolean apiRequestValidationEnabled = OpenApiSettings.isRequestValidationEnabled();
    private boolean apiResponseValidationEnabled = OpenApiSettings.isResponseValidationEnabled();
    private final OpenApiValidationPolicy openApiValidationPolicy;

    public OpenApiSpecification() {
        this(OpenApiSettings.getOpenApiValidationPolicy());
    }

    public OpenApiSpecification(OpenApiValidationPolicy openApiValidationPolicy) {
        this.openApiValidationPolicy = openApiValidationPolicy;
    }

    public static OpenApiSpecification from(String specUrl) {
        return OpenApiSpecification.from(specUrl, OpenApiSettings.getOpenApiValidationPolicy());
    }

    public static OpenApiSpecification from(String specUrl, OpenApiValidationPolicy openApiValidationPolicy) {
        OpenApiSpecification specification = new OpenApiSpecification(openApiValidationPolicy);
        specification.setSpecUrl(specUrl);
        try {
            OpenApiSpecification.determineUrlAlias(new URL(specUrl)).ifPresent(specification::addAlias);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return specification;
    }

    public static OpenApiSpecification from(URL specUrl) {
        return OpenApiSpecification.from(specUrl, OpenApiSettings.getOpenApiValidationPolicy());
    }

    public static OpenApiSpecification from(URL specUrl, OpenApiValidationPolicy openApiValidationPolicy) {
        OpenApiSpecification specification = new OpenApiSpecification(openApiValidationPolicy);
        OasDocument openApiDoc = specUrl.getProtocol().startsWith(HTTPS) ? OpenApiResourceLoader.fromSecuredWebResource(specUrl) : OpenApiResourceLoader.fromWebResource(specUrl);
        OpenApiValidationContext openApiValidationContext = OpenApiValidationContextLoader.fromSpec(OasModelHelper.toJson(openApiDoc), openApiValidationPolicy);
        specification.setOpenApiValidationContext(openApiValidationContext);
        OpenApiSpecification.determineUrlAlias(specUrl).ifPresent(specification::addAlias);
        specification.setSpecUrl(specUrl.toString());
        specification.initPathLookups();
        specification.setOpenApiDoc(openApiDoc);
        specification.setRequestUrl(String.format("%s://%s%s%s", specUrl.getProtocol(), specUrl.getHost(), specUrl.getPort() > 0 ? ":" + specUrl.getPort() : "", specification.rootContextPath));
        return specification;
    }

    public static OpenApiSpecification from(Resource resource) {
        return OpenApiSpecification.from(resource, OpenApiSettings.getOpenApiValidationPolicy());
    }

    public static OpenApiSpecification from(Resource resource, OpenApiValidationPolicy openApiValidationPolicy) {
        OpenApiSpecification specification = new OpenApiSpecification(openApiValidationPolicy);
        OasDocument openApiDoc = OpenApiResourceLoader.fromFile(resource);
        specification.setOpenApiValidationContext(OpenApiValidationContextLoader.fromSpec(OasModelHelper.toJson(openApiDoc), openApiValidationPolicy));
        specification.setOpenApiDoc(openApiDoc);
        OpenApiSpecification.determineResourceAlias(resource).ifPresent(specification::addAlias);
        String schemeToUse = Optional.ofNullable(OasModelHelper.getSchemes(openApiDoc)).orElse(Collections.singletonList(HTTP)).stream().filter(s -> s.equals(HTTP) || s.equals(HTTPS)).findFirst().orElse(HTTP);
        specification.setSpecUrl(resource.getLocation());
        specification.setRequestUrl(String.format("%s://%s%s", schemeToUse, OasModelHelper.getHost(openApiDoc), OasModelHelper.getBasePath(openApiDoc)));
        return specification;
    }

    public static OpenApiSpecification fromString(String openApi) {
        OpenApiSpecification specification = new OpenApiSpecification();
        OasDocument openApiDoc = OpenApiResourceLoader.fromString(openApi);
        specification.setOpenApiDoc(openApiDoc);
        specification.setOpenApiValidationContext(OpenApiValidationContextLoader.fromSpec(openApi, OpenApiSettings.getOpenApiValidationPolicy()));
        String schemeToUse = Optional.ofNullable(OasModelHelper.getSchemes(openApiDoc)).orElse(Collections.singletonList(HTTP)).stream().filter(s -> s.equals(HTTP) || s.equals(HTTPS)).findFirst().orElse(HTTP);
        specification.setSpecUrl("loaded from memory");
        specification.setRequestUrl(String.format("%s://%s%s", schemeToUse, OasModelHelper.getHost(openApiDoc), specification.rootContextPath));
        return specification;
    }

    public String getUid() {
        return this.uid;
    }

    public String getUniqueId(OasOperation oasOperation) {
        return this.operationToUniqueId.get(oasOperation);
    }

    public synchronized OasDocument getOpenApiDoc(TestContext context) {
        if (this.openApiDoc != null) {
            return this.openApiDoc;
        }
        if (this.specUrl != null) {
            Object resolvedSpecUrl = context.replaceDynamicContentInString(this.specUrl);
            if (((String)resolvedSpecUrl).startsWith("/")) {
                if (this.requestUrl != null) {
                    resolvedSpecUrl = this.requestUrl.endsWith("/") ? this.requestUrl + ((String)resolvedSpecUrl).substring(1) : this.requestUrl + (String)resolvedSpecUrl;
                } else if (this.httpClient != null && context.getReferenceResolver().isResolvable(this.httpClient, HttpClient.class)) {
                    String baseUrl = ((HttpClient)context.getReferenceResolver().resolve(this.httpClient, HttpClient.class)).getEndpointConfiguration().getRequestUrl();
                    resolvedSpecUrl = baseUrl.endsWith("/") ? baseUrl + ((String)resolvedSpecUrl).substring(1) : baseUrl + (String)resolvedSpecUrl;
                } else {
                    throw new CitrusRuntimeException("Failed to resolve OpenAPI spec URL from relative path %s - make sure to provide a proper base URL when using relative paths".formatted(resolvedSpecUrl));
                }
            }
            if (((String)resolvedSpecUrl).startsWith(HTTP)) {
                URL specWebResource = this.toSpecUrl((String)resolvedSpecUrl);
                if (((String)resolvedSpecUrl).startsWith(HTTPS)) {
                    this.initApiDoc(() -> OpenApiResourceLoader.fromSecuredWebResource(specWebResource));
                } else {
                    this.initApiDoc(() -> OpenApiResourceLoader.fromWebResource(specWebResource));
                }
                if (this.requestUrl == null) {
                    this.setRequestUrl(String.format("%s://%s%s%s", specWebResource.getProtocol(), specWebResource.getHost(), specWebResource.getPort() > 0 ? ":" + specWebResource.getPort() : "", OasModelHelper.getBasePath(this.openApiDoc)));
                }
            } else {
                Resource resource = Resources.create((String)resolvedSpecUrl);
                this.initApiDoc(() -> OpenApiResourceLoader.fromFile(resource));
                if (this.requestUrl == null) {
                    String schemeToUse = Optional.ofNullable(OasModelHelper.getSchemes(this.openApiDoc)).orElse(Collections.singletonList(HTTP)).stream().filter(s -> s.equals(HTTP) || s.equals(HTTPS)).findFirst().orElse(HTTP);
                    this.setRequestUrl(String.format("%s://%s%s", schemeToUse, OasModelHelper.getHost(this.openApiDoc), OasModelHelper.getBasePath(this.openApiDoc)));
                }
            }
        }
        this.setOpenApiValidationContext(OpenApiValidationContextLoader.fromSpec(OasModelHelper.toJson(this.openApiDoc), this.openApiValidationPolicy));
        return this.openApiDoc;
    }

    public OpenApiValidationContext getOpenApiValidationContext() {
        return this.openApiValidationContext;
    }

    private void setOpenApiValidationContext(OpenApiValidationContext openApiValidationContext) {
        this.openApiValidationContext = openApiValidationContext;
        this.openApiValidationContext.setResponseValidationEnabled(this.apiResponseValidationEnabled);
        this.openApiValidationContext.setRequestValidationEnabled(this.apiRequestValidationEnabled);
    }

    URL toSpecUrl(String resolvedSpecUrl) {
        try {
            return URI.create(resolvedSpecUrl).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to retrieve Open API specification as web resource: " + resolvedSpecUrl, e);
        }
    }

    void setOpenApiDoc(OasDocument openApiDoc) {
        this.initApiDoc(() -> openApiDoc);
    }

    private void initApiDoc(Supplier<OasDocument> openApiDocSupplier) {
        this.openApiDoc = openApiDocSupplier.get();
        this.aliases.addAll(this.collectAliases(this.openApiDoc));
        this.initPathLookups();
    }

    private void initPathLookups() {
        if (this.openApiDoc == null) {
            return;
        }
        this.determineUid();
        this.operationKeyToOperationPathAdapter.clear();
        OasModelHelper.visitOasOperations(this.openApiDoc, (oasPathItem, oasOperation) -> {
            String path = oasPathItem.getPath();
            if (StringUtils.isEmpty((String)path)) {
                logger.warn("Skipping path item without path.");
                return;
            }
            for (Map.Entry<String, OasOperation> operationEntry : OasModelHelper.getOperationMap(oasPathItem).entrySet()) {
                this.storeOperationPathAdapter(operationEntry.getValue(), oasPathItem);
            }
        });
    }

    private void determineUid() {
        if (this.uid != null) {
            this.aliases.remove(this.uid);
        }
        this.uid = DigestUtils.sha256Hex((String)(OasModelHelper.toJson(this.openApiDoc) + this.getFullContextPath()));
        this.aliases.add(this.uid);
    }

    private void storeOperationPathAdapter(OasOperation operation, OasPathItem pathItem) {
        String fullContextPath = this.getFullContextPath();
        String fullOperationPath = this.getFullPath(pathItem);
        String path = pathItem.getPath();
        String uniqueOperationId = OpenApiUtils.createFullPathOperationIdentifier(operation, fullOperationPath);
        this.operationToUniqueId.put(operation, uniqueOperationId);
        OperationPathAdapter operationPathAdapter = new OperationPathAdapter(path, fullContextPath, StringUtils.appendSegmentToUrlPath((String)fullContextPath, (String)path), operation, uniqueOperationId);
        this.operationKeyToOperationPathAdapter.put(uniqueOperationId, operationPathAdapter);
        if (StringUtils.hasText((String)operation.operationId)) {
            this.operationKeyToOperationPathAdapter.put(operation.operationId, operationPathAdapter);
        }
    }

    public String getSpecUrl() {
        return this.specUrl;
    }

    public void setSpecUrl(String specUrl) {
        this.specUrl = specUrl;
    }

    public String getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(String httpClient) {
        this.httpClient = httpClient;
    }

    public String getRequestUrl() {
        if (this.requestUrl == null) {
            return this.specUrl;
        }
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public boolean isApiRequestValidationEnabled() {
        return this.apiRequestValidationEnabled;
    }

    public void setApiRequestValidationEnabled(boolean enabled) {
        this.apiRequestValidationEnabled = enabled;
        if (this.openApiValidationContext != null) {
            this.openApiValidationContext.setRequestValidationEnabled(enabled);
        }
    }

    public boolean isApiResponseValidationEnabled() {
        return this.apiResponseValidationEnabled;
    }

    public void setApiResponseValidationEnabled(boolean enabled) {
        this.apiResponseValidationEnabled = enabled;
        if (this.openApiValidationContext != null) {
            this.openApiValidationContext.setResponseValidationEnabled(enabled);
        }
    }

    public boolean isGenerateOptionalFields() {
        return this.generateOptionalFields;
    }

    public void setGenerateOptionalFields(boolean generateOptionalFields) {
        this.generateOptionalFields = generateOptionalFields;
    }

    public AutoFillType getRequestAutoFill() {
        return this.requestAutoFill;
    }

    public void setRequestAutoFill(AutoFillType requestAutoFill) {
        this.requestAutoFill = requestAutoFill;
    }

    public OpenApiSpecification requestAutoFill(AutoFillType requestAutoFill) {
        this.setRequestAutoFill(requestAutoFill);
        return this;
    }

    public AutoFillType getResponseAutoFill() {
        return this.responseAutoFill;
    }

    public void setResponseAutoFill(AutoFillType responseAutoFill) {
        this.responseAutoFill = responseAutoFill;
    }

    public OpenApiSpecification responseAutoFill(AutoFillType responseAutoFill) {
        this.setResponseAutoFill(responseAutoFill);
        return this;
    }

    public String getRootContextPath() {
        return this.rootContextPath;
    }

    public void setRootContextPath(String rootContextPath) {
        this.rootContextPath = rootContextPath;
        this.initPathLookups();
    }

    public OpenApiSpecification rootContextPath(String rootContextPath) {
        this.setRootContextPath(rootContextPath);
        return this;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    private Collection<String> collectAliases(OasDocument document) {
        Extension xAlias;
        if (document == null) {
            return Collections.emptySet();
        }
        Info info = document.info;
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        if (StringUtils.hasText((String)info.title)) {
            set.add(info.title);
            if (StringUtils.hasText((String)info.version)) {
                set.add(info.title + "/" + info.version);
            }
        }
        if ((xAlias = info.getExtension("x-citrus-alias")) != null && xAlias.value != null) {
            set.add(xAlias.value.toString());
        }
        return set;
    }

    public Optional<OperationPathAdapter> getOperation(String operationKey, TestContext context) {
        if (operationKey == null) {
            return Optional.empty();
        }
        this.initOpenApiDoc(context);
        return Optional.ofNullable(this.operationKeyToOperationPathAdapter.get(operationKey));
    }

    public void initOpenApiDoc(TestContext context) {
        if (this.openApiDoc == null) {
            this.getOpenApiDoc(context);
        }
    }

    public String getFullPath(OasPathItem oasPathItem) {
        return StringUtils.appendSegmentToUrlPath((String)this.rootContextPath, (String)this.getFullBasePath(oasPathItem));
    }

    public String getFullBasePath(OasPathItem oasPathItem) {
        return StringUtils.appendSegmentToUrlPath((String)this.getApplicableBasePath(), (String)oasPathItem.getPath());
    }

    public String getFullContextPath() {
        return StringUtils.appendSegmentToUrlPath((String)this.rootContextPath, (String)this.getApplicableBasePath());
    }

    public void setNeglectBasePath(boolean neglectBasePath) {
        this.neglectBasePath = neglectBasePath;
        this.initPathLookups();
    }

    public OpenApiSpecification neglectBasePath(boolean neglectBasePath) {
        this.setNeglectBasePath(neglectBasePath);
        return this;
    }

    private String getApplicableBasePath() {
        return this.neglectBasePath ? "" : OasModelHelper.getBasePath(this.openApiDoc);
    }

    public OpenApiSpecification alias(String alias) {
        this.addAlias(alias);
        return this;
    }

    static Optional<String> determineResourceAlias(Resource openApiResource) {
        String resourceAlias = null;
        try {
            File file = openApiResource.getFile();
            if (file != null) {
                resourceAlias = file.getName();
                int index = resourceAlias.lastIndexOf(".");
                if (index != -1 && index != resourceAlias.length() - 1) {
                    resourceAlias = resourceAlias.substring(0, index);
                }
                return Optional.of(resourceAlias);
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        try {
            URL url = openApiResource.getURL();
            return OpenApiSpecification.determineUrlAlias(url);
        }
        catch (MalformedURLException e) {
            logger.error("Unable to determine resource alias from resource!", (Throwable)e);
            return Optional.ofNullable(resourceAlias);
        }
    }

    static Optional<String> determineUrlAlias(URL url) {
        String resourceAlias = null;
        if (url != null) {
            String urlString = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8).replace("\\", "/");
            int index = urlString.lastIndexOf("/");
            resourceAlias = urlString;
            if (index != -1 && index != urlString.length() - 1) {
                resourceAlias = resourceAlias.substring(index + 1);
            }
            if ((index = resourceAlias.lastIndexOf(".")) != -1 && index != resourceAlias.length() - 1) {
                resourceAlias = resourceAlias.substring(0, index);
            }
        }
        return Optional.ofNullable(resourceAlias);
    }
}

