/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.citrusframework.context.TestContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class OpenApiSupport {
    private static final Pattern STATUS_CODE_PATTERN = Pattern.compile("\\d+");
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE})).enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).build()).setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));

    private OpenApiSupport() {
    }

    public static ObjectMapper json() {
        return OBJECT_MAPPER;
    }

    public static Yaml yaml() {
        Representer representer = new Representer(new DumperOptions()){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null || propertyValue instanceof Collection && ((Collection)propertyValue).isEmpty() || propertyValue instanceof Map && ((Map)propertyValue).isEmpty()) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return new Yaml(representer);
    }

    public static HttpStatusCode getStatusCode(String statusCode, TestContext context) {
        String resolvedStatusCode = context.replaceDynamicContentInString(statusCode);
        if (STATUS_CODE_PATTERN.matcher(resolvedStatusCode).matches()) {
            return HttpStatusCode.valueOf((int)Integer.parseInt(resolvedStatusCode));
        }
        return (HttpStatusCode)Arrays.stream(HttpStatus.values()).filter(status -> status.name().equalsIgnoreCase(resolvedStatusCode)).findFirst().orElse(HttpStatus.OK);
    }
}

