/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import org.citrusframework.TestAction;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.openapi.actions.OpenApiClientRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.spi.AbstractReferenceResolverAwareTestActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.ObjectHelper;
import org.springframework.http.HttpStatus;

public class OpenApiClientActionBuilder
extends AbstractReferenceResolverAwareTestActionBuilder<TestAction>
implements OpenApiSpecificationSourceAwareBuilder<TestAction>,
org.citrusframework.actions.openapi.OpenApiClientActionBuilder<TestAction, OpenApiClientActionBuilder> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private Endpoint httpClient;
    private String httpClientUri;

    public OpenApiClientActionBuilder(Endpoint httpClient, OpenApiSpecificationSource openApiSpecificationSource) {
        this.httpClient = httpClient;
        this.openApiSpecificationSource = openApiSpecificationSource;
    }

    public OpenApiClientActionBuilder(String httpClientUri, OpenApiSpecificationSource openApiSpecificationSource) {
        this.httpClientUri = httpClientUri;
        this.openApiSpecificationSource = openApiSpecificationSource;
    }

    public OpenApiClientActionBuilder(OpenApiSpecificationSource openApiSpecificationSource) {
        this.openApiSpecificationSource = openApiSpecificationSource;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public OpenApiClientRequestActionBuilder send(String operationKey) {
        OpenApiClientRequestActionBuilder builder = new OpenApiClientRequestActionBuilder(this.openApiSpecificationSource, operationKey);
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.name("openapi:send-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiClientResponseActionBuilder receive(String operationKey) {
        return this.receive(operationKey, HttpStatus.OK);
    }

    public OpenApiClientResponseActionBuilder receive(String operationKey, HttpStatus status) {
        return this.receive(operationKey, status.name());
    }

    public OpenApiClientResponseActionBuilder receive(String operationKey, Object status) {
        if (status instanceof HttpStatus) {
            HttpStatus statusCode = (HttpStatus)status;
            return this.receive(operationKey, statusCode);
        }
        throw new CitrusRuntimeException("Invalid status code type: " + status.getClass().getName());
    }

    public OpenApiClientResponseActionBuilder receive(String operationKey, int statusCode) {
        return this.receive(operationKey, String.valueOf(statusCode));
    }

    public OpenApiClientResponseActionBuilder receive(String operationKey, String statusCode) {
        OpenApiClientResponseActionBuilder builder = new OpenApiClientResponseActionBuilder(this.openApiSpecificationSource, operationKey, statusCode);
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.name("openapi:receive-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull((Object)this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }
}

