/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasSchema;
import jakarta.servlet.http.Cookie;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiTestDataGenerator;
import org.citrusframework.openapi.actions.OpenApiPayloadBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiOperationToMessageHeadersProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.springframework.http.HttpMethod;

public class OpenApiClientRequestActionBuilder
extends HttpClientRequestActionBuilder
implements OpenApiSpecificationSourceAwareBuilder<SendMessageAction>,
org.citrusframework.actions.openapi.OpenApiClientRequestActionBuilder<SendMessageAction, HttpClientRequestActionBuilder.HttpMessageBuilderSupport, HttpClientRequestActionBuilder> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private final String operationKey;
    private OpenApiOperationToMessageHeadersProcessor openApiOperationToMessageHeadersProcessor;
    private Boolean schemaValidation;

    public OpenApiClientRequestActionBuilder(OpenApiSpecificationSource openApiSpec, String operationKey) {
        this(new HttpMessage(), openApiSpec, operationKey);
    }

    public OpenApiClientRequestActionBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpec, String operationKey) {
        this(openApiSpec, new OpenApiClientRequestMessageBuilder(httpMessage, openApiSpec, operationKey), httpMessage, operationKey);
    }

    public OpenApiClientRequestActionBuilder(OpenApiSpecificationSource openApiSpec, OpenApiClientRequestMessageBuilder messageBuilder, HttpMessage message, String operationKey) {
        super((MessageBuilder)messageBuilder, message);
        this.openApiSpecificationSource = openApiSpec;
        this.operationKey = operationKey;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public OpenApiClientRequestActionBuilder autoFill(AutoFillType autoFill) {
        ((OpenApiClientRequestMessageBuilder)((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder()).autoFill(autoFill);
        return this;
    }

    public SendMessageAction doBuild() {
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        if (this.schemaValidation == null) {
            OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
            this.schemaValidation = openApiValidationContext != null ? Boolean.valueOf(openApiValidationContext.isRequestValidationEnabled()) : Boolean.valueOf(OpenApiSettings.isRequestValidationEnabled());
        }
        if (this.schemaValidation.booleanValue() && !this.messageProcessors.contains(this.openApiOperationToMessageHeadersProcessor)) {
            this.openApiOperationToMessageHeadersProcessor = new OpenApiOperationToMessageHeadersProcessor(openApiSpecification, this.operationKey, OpenApiMessageType.REQUEST);
            this.process(this.openApiOperationToMessageHeadersProcessor);
        }
        return super.doBuild();
    }

    protected HttpClientRequestActionBuilder.HttpMessageBuilderSupport createHttpMessageBuilderSupport() {
        HttpClientRequestActionBuilder.HttpMessageBuilderSupport httpMessageBuilderSupport = super.createHttpMessageBuilderSupport();
        httpMessageBuilderSupport.schemaValidation(true);
        return httpMessageBuilderSupport;
    }

    public OpenApiClientRequestActionBuilder schemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        return this;
    }

    public static class OpenApiClientRequestMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecificationSource openApiSpecificationSource;
        private final String operationKey;
        private AutoFillType autoFill;

        public OpenApiClientRequestMessageBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpec, String operationKey) {
            super(httpMessage);
            this.openApiSpecificationSource = openApiSpec;
            this.operationKey = operationKey;
        }

        public OpenApiClientRequestMessageBuilder autoFill(AutoFillType autoFill) {
            this.autoFill = autoFill;
            return this;
        }

        public Message build(TestContext context, String messageType) {
            OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(context.getReferenceResolver());
            if (this.autoFill == null) {
                this.autoFill = openApiSpecification.getRequestAutoFill();
            }
            openApiSpecification.initOpenApiDoc(context);
            openApiSpecification.getOperation(this.operationKey, context).ifPresentOrElse(operationPathAdapter -> this.buildMessageFromOperation(openApiSpecification, (OperationPathAdapter)operationPathAdapter, context), () -> {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationKey, openApiSpecification.getSpecUrl()));
            });
            context.setVariable(openApiSpecification.getUid(), (Object)openApiSpecification);
            return super.build(context, messageType);
        }

        public Object buildMessagePayload(TestContext context, String messageType) {
            if (this.getPayloadBuilder() == null) {
                this.setPayloadBuilder((MessagePayloadBuilder)new OpenApiPayloadBuilder(this.getMessage().getPayload()));
            }
            return super.buildMessagePayload(context, messageType);
        }

        private void buildMessageFromOperation(OpenApiSpecification openApiSpecification, OperationPathAdapter operationPathAdapter, TestContext context) {
            OasOperation operation = operationPathAdapter.operation();
            String path = operationPathAdapter.fullPath();
            HttpMethod method = HttpMethod.valueOf((String)operationPathAdapter.operation().getMethod().toUpperCase(Locale.US));
            if (operation.parameters != null) {
                this.setMissingHeadersToRandomValues(openApiSpecification, context, operation);
                this.setMissingQueryParametersToRandomValues(openApiSpecification, context, operation);
                this.setMissingCookiesToRandomValues(openApiSpecification, context, operation);
            }
            String randomizedPath = path;
            this.setMissingBodyToRandomValue(openApiSpecification, context, operation);
            if (operation.parameters != null) {
                List<OasParameter> pathParams = operation.parameters.stream().filter(p -> "path".equals(p.in)).toList();
                for (OasParameter parameter : pathParams) {
                    Object value = context.getVariables().get(parameter.name);
                    if (value == null) {
                        if (this.autoFill == AutoFillType.NONE) continue;
                        context.setVariable(parameter.name, (Object)context.replaceDynamicContentInString(OpenApiTestDataGenerator.createRandomValueExpression((OasSchema)parameter.schema)));
                        randomizedPath = path.replace("{" + parameter.name + "}", "${" + parameter.name + "}");
                        continue;
                    }
                    randomizedPath = path.replace("{" + parameter.name + "}", "${" + parameter.name + "}");
                }
            }
            OasModelHelper.getRequestContentType(operation).ifPresent(contentType -> this.getMessage().setHeader("Content-Type", contentType));
            this.getMessage().path(randomizedPath);
            this.getMessage().method(method);
        }

        protected String getDefinedPathParameter(TestContext context, String name) {
            if (context.getVariables().containsKey(name)) {
                return "${" + name + "}";
            }
            return null;
        }

        private void setMissingBodyToRandomValue(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            String payloadString;
            Object object;
            if (this.getMessage().getPayload() == null || (object = this.getMessage().getPayload()) instanceof String && (payloadString = (String)object).isEmpty()) {
                Optional<OasSchema> body = OasModelHelper.getRequestBodySchema(openApiSpecification.getOpenApiDoc(context), operation);
                body.ifPresent(oasSchema -> {
                    if (this.autoFill.shouldFill(Boolean.valueOf(OasModelHelper.isOperationRequestBodyRequired(openApiSpecification.getOpenApiDoc(context), operation)))) {
                        this.getMessage().setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(oasSchema, openApiSpecification));
                    }
                });
            }
        }

        private void setMissingQueryParametersToRandomValues(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            operation.parameters.stream().filter(param -> "query".equals(param.in)).filter(param -> !this.getMessage().getQueryParams().containsKey(param.getName())).filter(param -> this.autoFill.shouldFill(param.required)).forEach(param -> {
                Object queryParameterValue = context.getVariables().get(param.getName());
                if (queryParameterValue == null) {
                    queryParameterValue = OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, openApiSpecification, context);
                    if (OasModelHelper.isArrayType((OasSchema)param.schema)) {
                        String arrayString = queryParameterValue.toString();
                        arrayString = context.replaceDynamicContentInString(arrayString.substring(1, arrayString.length() - 1));
                        queryParameterValue = arrayString.split(",");
                    }
                }
                try {
                    if (queryParameterValue instanceof String[]) {
                        String[] stringArray = (String[])queryParameterValue;
                        Arrays.stream(stringArray).forEach(value -> this.getMessage().queryParam(param.getName(), value));
                    } else {
                        this.getMessage().queryParam(param.getName(), queryParameterValue.toString());
                    }
                }
                catch (Exception e) {
                    TestActionBuilder.logger.warn("Unable to set missing required query parameter to random value: {}", param);
                }
            });
        }

        private void setMissingHeadersToRandomValues(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            List configuredHeaders = this.getHeaderBuilders().stream().flatMap(b -> b.builderHeaders(context).keySet().stream()).toList();
            operation.parameters.stream().filter(param -> "header".equals(param.in)).filter(param -> this.getMessage().getHeader(param.getName()) == null && !configuredHeaders.contains(param.getName())).filter(param -> this.autoFill.shouldFill(param.required)).forEach(param -> {
                Object headerValue = context.getVariables().get(param.getName());
                if (headerValue == null) {
                    headerValue = OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, openApiSpecification, context);
                }
                this.getMessage().setHeader(param.getName(), headerValue);
            });
        }

        private void setMissingCookiesToRandomValues(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            List configuredHeaders = this.getHeaderBuilders().stream().flatMap(messageHeaderBuilder -> messageHeaderBuilder.builderHeaders(context).keySet().stream()).toList();
            operation.parameters.stream().filter(param -> "cookie".equals(param.in)).filter(param -> this.getMessage().getHeader(param.getName()) == null && !configuredHeaders.contains(param.getName())).filter(param -> this.autoFill.shouldFill(param.required)).forEach(param -> {
                Object headerValue = context.getVariables().get(param.getName());
                if (headerValue == null) {
                    headerValue = OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, openApiSpecification, context);
                }
                this.getMessage().cookie(new Cookie(param.getName(), headerValue.toString()));
            });
        }
    }
}

