/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasResponse;
import java.util.HashMap;
import java.util.Optional;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientResponseActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiSupport;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.util.OpenApiUtils;
import org.citrusframework.openapi.validation.OpenApiMessageValidationContext;
import org.citrusframework.openapi.validation.OpenApiOperationToMessageHeadersProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.citrusframework.validation.context.ValidationContext;

public class OpenApiClientResponseActionBuilder
extends HttpClientResponseActionBuilder
implements OpenApiSpecificationSourceAwareBuilder<ReceiveMessageAction>,
org.citrusframework.actions.openapi.OpenApiClientResponseActionBuilder<ReceiveMessageAction, HttpClientResponseActionBuilder.HttpMessageBuilderSupport, HttpClientResponseActionBuilder> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private final String operationKey;
    private OpenApiOperationToMessageHeadersProcessor openApiOperationToMessageHeadersProcessor;
    private Boolean schemaValidation;

    public OpenApiClientResponseActionBuilder(OpenApiSpecificationSource openApiSpec, String operationKey, String statusCode) {
        this(new HttpMessage(), openApiSpec, operationKey, statusCode);
    }

    public OpenApiClientResponseActionBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource, String operationKey, String statusCode) {
        this(openApiSpecificationSource, new OpenApiClientResponseMessageBuilder(httpMessage, openApiSpecificationSource, operationKey, statusCode), httpMessage, operationKey);
    }

    public OpenApiClientResponseActionBuilder(OpenApiSpecificationSource openApiSpec, OpenApiClientResponseMessageBuilder messageBuilder, HttpMessage message, String operationKey) {
        super((MessageBuilder)messageBuilder, message);
        this.openApiSpecificationSource = openApiSpec;
        this.operationKey = operationKey;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    protected void reconcileValidationContexts() {
        super.reconcileValidationContexts();
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        if (this.schemaValidation == null) {
            OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
            this.schemaValidation = openApiValidationContext != null ? Boolean.valueOf(openApiValidationContext.isResponseValidationEnabled()) : Boolean.valueOf(OpenApiSettings.isRequestValidationEnabled());
        }
        if (this.getValidationContexts().stream().noneMatch(OpenApiMessageValidationContext.class::isInstance)) {
            this.validate((ValidationContext)OpenApiMessageValidationContext.Builder.openApi(openApiSpecification).schemaValidation(this.schemaValidation).build());
        }
    }

    public ReceiveMessageAction doBuild() {
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        if (!this.messageProcessors.contains(this.openApiOperationToMessageHeadersProcessor)) {
            this.openApiOperationToMessageHeadersProcessor = new OpenApiOperationToMessageHeadersProcessor(openApiSpecification, this.operationKey, OpenApiMessageType.RESPONSE);
            this.process(this.openApiOperationToMessageHeadersProcessor);
        }
        return super.doBuild();
    }

    public OpenApiClientResponseActionBuilder schemaValidation(boolean enabled) {
        this.schemaValidation = enabled;
        return this;
    }

    public static class OpenApiClientResponseMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecificationSource openApiSpecificationSource;
        private final String operationKey;
        private final HttpMessage httpMessage;
        private String statusCode;

        public OpenApiClientResponseMessageBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource, String operationKey, String statusCode) {
            super(httpMessage);
            this.openApiSpecificationSource = openApiSpecificationSource;
            this.operationKey = operationKey;
            this.statusCode = statusCode;
            this.httpMessage = httpMessage;
        }

        public OpenApiClientResponseMessageBuilder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Message build(TestContext context, String messageType) {
            OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(context.getReferenceResolver());
            openApiSpecification.getOperation(this.operationKey, context).ifPresentOrElse(operationPathAdapter -> this.buildMessageFromOperation(openApiSpecification, (OperationPathAdapter)operationPathAdapter, context), () -> {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationKey, openApiSpecification.getSpecUrl()));
            });
            return super.build(context, messageType);
        }

        private void buildMessageFromOperation(OpenApiSpecification openApiSpecification, OperationPathAdapter operationPathAdapter, TestContext context) {
            OasOperation operation = operationPathAdapter.operation();
            HashMap currentHeaders = new HashMap(this.httpMessage.getHeaders());
            if (operation.responses != null) {
                Optional<OasResponse> responseForRandomGeneration = OasModelHelper.getResponseForRandomGeneration(openApiSpecification.getOpenApiDoc(context), operation, String.valueOf(OpenApiSupport.getStatusCode(this.statusCode, context).value()), null);
                responseForRandomGeneration.ifPresent(oasResponse -> OpenApiUtils.fillMessageTypeFromResponse(openApiSpecification, this.httpMessage, operation, oasResponse));
            }
            this.httpMessage.status(OpenApiSupport.getStatusCode(this.statusCode, context));
            this.httpMessage.getHeaders().putAll(currentHeaders);
        }
    }
}

