/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import java.util.Objects;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.openapi.OpenApiRepository;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.util.OpenApiUtils;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class OpenApiSpecificationSource {
    private OpenApiSpecification openApiSpecification;
    private String openApiAlias;
    private String httpClient;

    public OpenApiSpecificationSource(OpenApiSpecification openApiSpecification) {
        this.openApiSpecification = openApiSpecification;
    }

    public OpenApiSpecificationSource(String openApiAlias) {
        this.openApiAlias = openApiAlias;
    }

    public OpenApiSpecification resolve(ReferenceResolver resolver) {
        if (this.openApiSpecification == null) {
            if (!StringUtils.isEmpty((String)this.openApiAlias)) {
                this.openApiSpecification = resolver.resolveAll(OpenApiRepository.class).values().stream().map(openApiRepository -> openApiRepository.openApi(this.openApiAlias)).filter(Objects::nonNull).findFirst().orElseGet(() -> resolver.resolveAll(OpenApiSpecification.class).values().stream().filter(specification -> specification.getAliases().contains(this.openApiAlias)).findFirst().orElseThrow(() -> new CitrusRuntimeException("Unable to resolve OpenApiSpecification from alias '%s'. Known aliases for open api specs are '%s'".formatted(this.openApiAlias, OpenApiUtils.getKnownOpenApiAliases(resolver)))));
            } else {
                throw new CitrusRuntimeException("Unable to resolve OpenApiSpecification. Neither OpenAPI spec, nor OpenAPI  alias are specified.");
            }
        }
        if (this.httpClient != null) {
            this.openApiSpecification.setHttpClient(this.httpClient);
        }
        return this.openApiSpecification;
    }

    public void setHttpClient(String httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(Endpoint endpoint) {
        HttpClient client;
        if (endpoint instanceof HttpClient && (client = (HttpClient)endpoint).getEndpointConfiguration().getRequestUrl() != null) {
            this.httpClient = client.getEndpointConfiguration().getRequestUrl();
        }
    }
}

