/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.model.v3;

import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.openapi.model.OasAdapter;
import org.citrusframework.openapi.model.OasModelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Oas30ModelHelper {
    private static final Logger logger = LoggerFactory.getLogger(Oas30ModelHelper.class);
    public static final String NO_URL_ERROR_MESSAGE = "Unable to determine base path from server URL: %s";

    private Oas30ModelHelper() {
    }

    public static String getHost(Oas30Document openApiDoc) {
        if (openApiDoc.servers == null || openApiDoc.servers.isEmpty()) {
            return "localhost";
        }
        String serverUrl = Oas30ModelHelper.resolveUrl((Server)openApiDoc.servers.get(0));
        if (serverUrl.startsWith("http")) {
            return URI.create(serverUrl).getHost();
        }
        return "localhost";
    }

    public static List<String> getSchemes(Oas30Document openApiDoc) {
        if (openApiDoc.servers == null || openApiDoc.servers.isEmpty()) {
            return Collections.emptyList();
        }
        return openApiDoc.servers.stream().map(Oas30ModelHelper::resolveUrl).map(serverUrl -> {
            try {
                return URI.create(serverUrl).toURL().getProtocol();
            }
            catch (Exception e) {
                logger.warn(String.format(NO_URL_ERROR_MESSAGE, serverUrl), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    public static boolean isCompositeSchema(@Nullable Oas30Schema schema) {
        return schema != null && (schema.anyOf != null || schema.oneOf != null || schema.allOf != null);
    }

    public static String getBasePath(Oas30Document openApiDoc) {
        if (openApiDoc.servers == null || openApiDoc.servers.isEmpty()) {
            return "/";
        }
        Server server = (Server)openApiDoc.servers.get(0);
        String serverUrl = Oas30ModelHelper.resolveUrl(server);
        String basePath = serverUrl.startsWith("http") ? URI.create(serverUrl).getPath() : serverUrl;
        return basePath.startsWith("/") ? basePath : "/" + basePath;
    }

    public static Map<String, OasSchema> getSchemaDefinitions(Oas30Document openApiDoc) {
        if (openApiDoc.components == null || openApiDoc.components.schemas == null) {
            return Collections.emptyMap();
        }
        return openApiDoc.components.schemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Optional<OasSchema> getSchema(Oas30Response response) {
        Map content = response.content;
        if (content == null) {
            return Optional.empty();
        }
        return content.entrySet().stream().filter(entry -> !Oas30ModelHelper.isFormDataMediaType((String)entry.getKey())).filter(entry -> ((Oas30MediaType)entry.getValue()).schema != null).map(entry -> ((Oas30MediaType)entry.getValue()).schema).findFirst();
    }

    public static Optional<OasAdapter<OasSchema, String>> getSchema(Oas30Operation ignoredOas30Operation, Oas30Response response, List<String> acceptedMediaTypes) {
        acceptedMediaTypes = (acceptedMediaTypes = OasModelHelper.resolveAllTypes(acceptedMediaTypes)).isEmpty() ? OasModelHelper.DEFAULT_ACCEPTED_MEDIA_TYPES : acceptedMediaTypes;
        Map content = response.content;
        if (content == null) {
            return Optional.empty();
        }
        String selectedMediaType = null;
        Oas30Schema selectedSchema = null;
        for (String type : acceptedMediaTypes) {
            Oas30MediaType oas30MediaType;
            if (Oas30ModelHelper.isFormDataMediaType(type) || (oas30MediaType = (Oas30MediaType)content.get(type)) == null) continue;
            selectedMediaType = type;
            selectedSchema = oas30MediaType.schema;
            break;
        }
        return selectedSchema == null && selectedMediaType == null ? Optional.empty() : Optional.of(new OasAdapter<Object, Object>(selectedSchema, selectedMediaType));
    }

    public static Optional<OasSchema> getRequestBodySchema(Oas30Document openApiDoc, Oas30Operation operation) {
        if (operation.requestBody == null) {
            return Optional.empty();
        }
        Oas30RequestBody bodyToUse = operation.requestBody;
        if (openApiDoc.components != null && openApiDoc.components.requestBodies != null && bodyToUse.$ref != null) {
            bodyToUse = (Oas30RequestBody)openApiDoc.components.requestBodies.get(OasModelHelper.getReferenceName(bodyToUse.$ref));
        }
        if (bodyToUse.content == null) {
            return Optional.empty();
        }
        return bodyToUse.content.entrySet().stream().filter(entry -> !Oas30ModelHelper.isFormDataMediaType((String)entry.getKey())).filter(entry -> ((Oas30MediaType)entry.getValue()).schema != null).findFirst().map(Map.Entry::getValue).map(oas30MediaType -> oas30MediaType.schema);
    }

    public static boolean isOperationRequestBodyRequired(Oas30Document openApiDoc, Oas30Operation operation) {
        return operation.requestBody != null && Boolean.TRUE == operation.requestBody.required;
    }

    public static Optional<String> getRequestContentType(Oas30Operation operation) {
        if (operation.requestBody == null || operation.requestBody.content == null) {
            return Optional.empty();
        }
        return operation.requestBody.content.entrySet().stream().filter(entry -> ((Oas30MediaType)entry.getValue()).schema != null).map(Map.Entry::getKey).findFirst();
    }

    public static Collection<String> getResponseTypes(Oas30Operation operation, Oas30Response response) {
        if (operation == null) {
            return Collections.emptySet();
        }
        return response.content != null ? response.content.keySet() : Collections.emptyList();
    }

    public static Map<String, OasSchema> getRequiredHeaders(Oas30Document oasDocument, Oas30Response response) {
        if (response.headers == null) {
            return Collections.emptyMap();
        }
        return response.headers.entrySet().stream().filter(entry -> Boolean.TRUE.equals(((Oas30Header)entry.getValue()).required)).map(entry -> Map.entry((String)entry.getKey(), Oas30ModelHelper.resolveRequiredSchema(oasDocument, (Oas30Header)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, OasSchema> getHeaders(Oas30Document oasDocument, Oas30Response response) {
        if (response.headers == null) {
            return Collections.emptyMap();
        }
        return response.headers.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), Oas30ModelHelper.resolveRequiredSchema(oasDocument, (Oas30Header)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static OasSchema resolveRequiredSchema(Oas30Document oasDocument, Oas30Header oas30Header) {
        Object oasSchema = Objects.isNull(oas30Header.schema) ? Oas30ModelHelper.getSchemaDefinitions(oasDocument).get(OasModelHelper.getReferenceName(oas30Header.getReference())) : oas30Header.schema;
        if (Objects.isNull(oasSchema)) {
            throw new CitrusRuntimeException("Failed to resolve schema in OpenAPI specification, tried reference as well!");
        }
        return oasSchema;
    }

    private static boolean isFormDataMediaType(String type) {
        return Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data").contains(type);
    }

    private static String resolveUrl(Server server) {
        String url = Optional.ofNullable(server.url).orElse("/");
        if (server.variables != null) {
            for (Map.Entry variable : server.variables.entrySet()) {
                String defaultValue = Optional.ofNullable(((ServerVariable)variable.getValue()).default_).orElse("");
                url = url.replaceAll(String.format("\\{%s\\}", variable.getKey()), defaultValue);
            }
        }
        return url;
    }

    public static Optional<OasSchema> getParameterSchema(Oas30Parameter parameter) {
        return Optional.ofNullable((OasSchema)parameter.schema);
    }
}

