/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.random.RandomConfiguration;
import org.citrusframework.openapi.random.RandomModelBuilder;

public class RandomContext {
    private final OpenApiSpecification specification;
    private final RandomModelBuilder randomModelBuilder;
    private final Map<String, Object> contextVariables = new HashMap<String, Object>();
    private Map<String, OasSchema> schemaDefinitions;

    public RandomContext() {
        this.randomModelBuilder = new RandomModelBuilder(false);
        this.specification = null;
    }

    public RandomContext(OpenApiSpecification specification, boolean quote) {
        this.specification = specification;
        this.randomModelBuilder = new RandomModelBuilder(quote);
    }

    public OpenApiSpecification getSpecification() {
        return this.specification;
    }

    public RandomModelBuilder getRandomModelBuilder() {
        return this.randomModelBuilder;
    }

    public void generate(OasSchema schema) {
        this.doGenerate(this.resolveSchema(schema));
    }

    void doGenerate(OasSchema resolvedSchema) {
        RandomConfiguration.RANDOM_CONFIGURATION.getGenerator(resolvedSchema).generateIntoContext(this, resolvedSchema);
    }

    @Nullable
    OasSchema resolveSchema(OasSchema schema) {
        if (OasModelHelper.isReferenceType(schema)) {
            if (this.schemaDefinitions == null) {
                this.schemaDefinitions = this.getSchemaDefinitions();
            }
            schema = this.schemaDefinitions.get(OasModelHelper.getReferenceName(schema.$ref));
        }
        return schema;
    }

    Map<String, OasSchema> getSchemaDefinitions() {
        return this.specification != null ? OasModelHelper.getSchemaDefinitions(this.specification.getOpenApiDoc(null)) : Collections.emptyMap();
    }

    public <T> T get(String key, Function<String, T> mappingFunction) {
        return (T)this.contextVariables.computeIfAbsent(key, mappingFunction);
    }
}

