/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import java.util.ArrayList;
import java.util.LinkedHashMap;

interface RandomElement {
    default public void push(RandomElement value) {
        throw new UnsupportedOperationException();
    }

    default public void push(String key, RandomElement value) {
        throw new UnsupportedOperationException();
    }

    public static class RandomValue
    implements RandomElement {
        private Object value;

        public RandomValue() {
        }

        public RandomValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void push(RandomElement pushedValue) {
            Object object = this.value;
            if (object instanceof RandomElement) {
                RandomElement randomElement = (RandomElement)object;
                randomElement.push(pushedValue);
            } else {
                this.value = pushedValue;
            }
        }

        @Override
        public void push(String key, RandomElement pushedValue) {
            Object object = this.value;
            if (!(object instanceof RandomElement)) {
                throw new IllegalStateException("Cannot push key/value to value: " + this.value);
            }
            RandomElement randomElement = (RandomElement)object;
            randomElement.push(key, pushedValue);
        }
    }

    public static class RandomObject
    extends LinkedHashMap<String, RandomElement>
    implements RandomElement {
        @Override
        public void push(String key, RandomElement value) {
            this.put(key, value);
        }

        @Override
        public void push(RandomElement value) {
            if (value instanceof RandomObject) {
                RandomObject randomObject = (RandomObject)value;
                this.putAll(randomObject);
                return;
            }
            throw new IllegalArgumentException("Value must be an instance of RandomObject");
        }
    }

    public static class RandomList
    extends ArrayList<RandomElement>
    implements RandomElement {
        @Override
        public void push(RandomElement value) {
            this.add(value);
        }

        @Override
        public void push(String key, RandomElement value) {
            Object lastElement;
            if (!this.isEmpty() && (lastElement = this.get(this.size() - 1)) instanceof RandomElement) {
                RandomElement randomElement = (RandomElement)lastElement;
                randomElement.push(key, value);
            }
        }
    }
}

