/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;

public class RandomEnumGenerator
extends RandomGenerator {
    @Override
    public boolean handles(@Nullable OasSchema enumSchema) {
        return enumSchema != null && enumSchema.enum_ != null;
    }

    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema enumSchema) {
        List anEnum = enumSchema.enum_;
        if (anEnum != null) {
            String enumValues = enumSchema.enum_.stream().map(value -> "'" + value + "'").collect(Collectors.joining(","));
            randomContext.getRandomModelBuilder().appendSimpleQuoted("citrus:randomEnumValue(%s)".formatted(enumValues));
        }
    }
}

