/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.citrusframework.openapi.random.RandomElement;
import org.citrusframework.openapi.random.RandomModelBuilder;
import org.citrusframework.util.StringUtils;

final class RandomModelJsonWriter {
    private RandomModelJsonWriter() {
    }

    static String toString(RandomModelBuilder randomModelBuilder) {
        StringBuilder builder = new StringBuilder();
        RandomModelJsonWriter.appendObject(builder, randomModelBuilder.deque);
        return builder.toString();
    }

    private static void appendObject(StringBuilder builder, Object object) {
        if (object instanceof Deque) {
            Deque deque = (Deque)object;
            while (!deque.isEmpty()) {
                RandomModelJsonWriter.appendObject(builder, deque.pop());
            }
        } else if (object instanceof RandomElement.RandomObject) {
            RandomElement.RandomObject randomObject = (RandomElement.RandomObject)object;
            RandomModelJsonWriter.appendJsonObject(builder, randomObject);
        } else if (object instanceof RandomElement.RandomList) {
            RandomElement.RandomList randomList = (RandomElement.RandomList)object;
            RandomModelJsonWriter.appendArray(builder, randomList);
        } else if (object instanceof String) {
            String string = (String)object;
            builder.append(string);
        } else if (object instanceof RandomElement.RandomValue) {
            RandomElement.RandomValue randomValue = (RandomElement.RandomValue)object;
            RandomModelJsonWriter.appendObject(builder, randomValue.getValue());
        }
    }

    private static void appendArray(StringBuilder builder, List<RandomElement> list) {
        builder.append("[");
        list.forEach(listValue -> {
            RandomModelJsonWriter.appendObject(builder, listValue);
            builder.append(",");
        });
        StringUtils.trimTrailingComma((StringBuilder)builder);
        builder.append("]");
    }

    private static void appendJsonObject(StringBuilder builder, Map<String, RandomElement> map) {
        builder.append("{");
        for (Map.Entry<String, RandomElement> entry : map.entrySet()) {
            String key = entry.getKey();
            RandomElement value = entry.getValue();
            builder.append("\"");
            builder.append(key);
            builder.append("\": ");
            RandomModelJsonWriter.appendObject(builder, value);
            builder.append(",");
        }
        StringUtils.trimTrailingComma((StringBuilder)builder);
        builder.append("}");
    }
}

