/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;
import org.citrusframework.openapi.util.OpenApiUtils;

public class RandomObjectGenerator
extends RandomGenerator {
    private static final String OBJECT_STACK = "OBJECT_STACK";
    private static final OasSchema OBJECT_SCHEMA = new Oas30Schema();

    public RandomObjectGenerator() {
        super(OBJECT_SCHEMA);
    }

    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema schema) {
        Deque objectStack = randomContext.get(OBJECT_STACK, k -> new ArrayDeque());
        if (objectStack.contains(schema)) {
            return;
        }
        objectStack.push(schema);
        randomContext.getRandomModelBuilder().object(() -> {
            if (schema.properties != null) {
                for (Map.Entry entry : schema.properties.entrySet()) {
                    if (!randomContext.getSpecification().isGenerateOptionalFields() && !OpenApiUtils.isRequired(schema, (String)entry.getKey())) continue;
                    randomContext.getRandomModelBuilder().property((String)entry.getKey(), () -> randomContext.generate((OasSchema)entry.getValue()));
                }
            }
        });
        objectStack.pop();
    }

    static {
        RandomObjectGenerator.OBJECT_SCHEMA.type = "object";
    }
}

