/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.util;

import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.MessageType;
import org.citrusframework.openapi.OpenApiRepository;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public final class OpenApiUtils {
    private OpenApiUtils() {
    }

    public static String getMethodPath(@Nonnull String method, @Nonnull String path) {
        if (StringUtils.hasText((String)path) && path.startsWith("/")) {
            path = path.substring(1);
        }
        return String.format("%s_/%s", method.toUpperCase(), path);
    }

    public static String createFullPathOperationIdentifier(OasOperation oasOperation, String path) {
        return OpenApiUtils.createFullPathOperationIdentifier(oasOperation.getMethod(), path);
    }

    public static String createFullPathOperationIdentifier(String method, String path) {
        return String.format("%s_%s", method.toUpperCase(), path);
    }

    public static boolean isAnyNumberScheme(@Nullable OasSchema schema) {
        return schema != null && ("integer".equalsIgnoreCase(schema.type) || "number".equalsIgnoreCase(schema.type));
    }

    public static boolean isRequired(OasSchema schema, String field) {
        if (schema.required == null) {
            return true;
        }
        return schema.required.contains(field);
    }

    public static String getKnownOpenApiAliases(ReferenceResolver resolver) {
        return resolver.resolveAll(OpenApiRepository.class).values().stream().flatMap(openApiRepository -> openApiRepository.getOpenApiSpecifications().stream()).flatMap(spec -> spec.getAliases().stream()).collect(Collectors.joining(", "));
    }

    public static void fillMessageTypeFromResponse(OpenApiSpecification openApiSpecification, HttpMessage httpMessage, @Nullable OasOperation operation, @Nullable OasResponse response) {
        if (operation == null || response == null) {
            return;
        }
        Optional<OasSchema> responseSchema = OasModelHelper.getSchema(response);
        responseSchema.ifPresent(oasSchema -> {
            Collection<String> responseTypes;
            OasSchema resolvedSchema = OasModelHelper.resolveSchema(openApiSpecification.getOpenApiDoc(null), oasSchema);
            if ((OasModelHelper.isObjectType(resolvedSchema) || OasModelHelper.isObjectArrayType(resolvedSchema)) && (responseTypes = OasModelHelper.getResponseTypes(operation, response)).contains("application/json")) {
                httpMessage.setType(MessageType.JSON);
            }
        });
    }
}

