/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.openapi.validation.OpenApiMessageValidationContext;
import org.citrusframework.openapi.validation.schema.OpenApiSchemaValidation;
import org.citrusframework.validation.AbstractMessageValidator;

public class OpenApiMessageValidator
extends AbstractMessageValidator<OpenApiMessageValidationContext> {
    private final OpenApiSchemaValidation schemaValidator;

    public OpenApiMessageValidator() {
        this(new OpenApiSchemaValidation());
    }

    public OpenApiMessageValidator(OpenApiSchemaValidation schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    protected Class<OpenApiMessageValidationContext> getRequiredValidationContextType() {
        return OpenApiMessageValidationContext.class;
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, OpenApiMessageValidationContext validationContext) {
        logger.debug("Start OpenAPI message validation ...");
        if (validationContext.isSchemaValidationEnabled()) {
            this.schemaValidator.validate(receivedMessage, context, validationContext);
        }
        logger.debug("OpenAPI message validation successful: All values OK");
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return message != null && message.getHeader("citrus_oas_unique_operation_id") != null;
    }
}

