/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.ValidationReport;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageUtils;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiValidator;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.springframework.util.MultiValueMap;

public class OpenApiRequestValidator
extends OpenApiValidator {
    public OpenApiRequestValidator(OpenApiSpecification openApiSpecification) {
        super(openApiSpecification);
    }

    @Override
    protected String getType() {
        return "request";
    }

    public void validateRequest(OperationPathAdapter operationPathAdapter, HttpMessage requestMessage) {
        ValidationReport validationReport;
        if (this.openApiInteractionValidator != null && (validationReport = this.openApiInteractionValidator.validateRequest(this.createRequestFromMessage(operationPathAdapter, requestMessage))).hasErrors()) {
            throw new ValidationException(this.constructErrorMessage(operationPathAdapter, validationReport));
        }
    }

    public ValidationReport validateRequestToReport(OperationPathAdapter operationPathAdapter, HttpMessage requestMessage) {
        if (this.openApiInteractionValidator != null) {
            return this.openApiInteractionValidator.validateRequest(this.createRequestFromMessage(operationPathAdapter, requestMessage));
        }
        return ValidationReport.empty();
    }

    Request createRequestFromMessage(OperationPathAdapter operationPathAdapter, HttpMessage httpMessage) {
        Object payload = httpMessage.getPayload();
        String contextPath = operationPathAdapter.contextPath();
        String requestUri = (String)httpMessage.getHeader("citrus_http_request_uri");
        if (contextPath != null && requestUri.startsWith(contextPath)) {
            requestUri = requestUri.substring(contextPath.length());
        }
        SimpleRequest.Builder requestBuilder = new SimpleRequest.Builder(httpMessage.getRequestMethod().asHttpMethod().name(), requestUri);
        if (payload != null) {
            requestBuilder = requestBuilder.withBody(this.convertPayload(payload));
        }
        SimpleRequest.Builder finalRequestBuilder = requestBuilder;
        finalRequestBuilder.withAccept(new String[]{httpMessage.getAccept()});
        HttpMessageUtils.getQueryParameterMap((HttpMessage)httpMessage).forEach((key, value) -> {
            List<String> queryParamValues = value.stream().map(this::urlDecodeIfNeccessary).toList();
            finalRequestBuilder.withQueryParam(key, queryParamValues);
        });
        httpMessage.getHeaders().forEach((key, value) -> {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                collection.forEach(v -> finalRequestBuilder.withHeader(key, new String[]{v != null ? v.toString() : null}));
            } else {
                finalRequestBuilder.withHeader(key, new String[]{value != null ? value.toString() : null});
            }
        });
        httpMessage.getCookies().forEach(cookie -> finalRequestBuilder.withHeader("Cookie", new String[]{URLDecoder.decode(cookie.getName() + "=" + cookie.getValue(), FileUtils.getDefaultCharset())}));
        return requestBuilder.build();
    }

    private String urlDecodeIfNeccessary(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        String valueToTest = value.trim();
        if (valueToTest.startsWith("%7B") && valueToTest.endsWith("%7D") || valueToTest.startsWith("%5B") && valueToTest.endsWith("%5D")) {
            return URLDecoder.decode(value, FileUtils.getDefaultCharset());
        }
        return value;
    }

    private String convertPayload(Object payload) {
        if (payload instanceof MultiValueMap) {
            MultiValueMap multiValueMap = (MultiValueMap)payload;
            return this.serializeForm(multiValueMap, StandardCharsets.UTF_8);
        }
        return payload != null ? payload.toString() : null;
    }

    private String serializeForm(MultiValueMap<?, ?> formData, Charset charset) {
        StringBuilder builder = new StringBuilder();
        formData.forEach((name, values) -> values.forEach(value -> {
            if (!builder.isEmpty()) {
                builder.append('&');
            }
            builder.append(URLEncoder.encode(name.toString(), charset));
            if (value != null) {
                builder.append('=');
                builder.append(URLEncoder.encode(String.valueOf(value), charset));
            }
        }));
        return builder.toString();
    }
}

