/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation.schema;

import com.atlassian.oai.validator.report.ValidationReport;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.openapi.OpenApiRepository;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.util.OpenApiUtils;
import org.citrusframework.openapi.validation.OpenApiMessageValidationContext;
import org.citrusframework.openapi.validation.OpenApiRequestValidator;
import org.citrusframework.openapi.validation.OpenApiResponseValidator;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.SchemaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiSchemaValidation
implements SchemaValidator<OpenApiMessageValidationContext> {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiSchemaValidation.class);

    public void validate(Message message, TestContext context, OpenApiMessageValidationContext validationContext) {
        HttpMessage httpMessage;
        logger.debug("Starting OpenApi schema validation ...");
        if (!(message instanceof HttpMessage) || (httpMessage = (HttpMessage)message).getHeader("Location") != null) {
            return;
        }
        ValidationReportData validationReportData = this.validate(context, httpMessage, this.findSchemaRepositories(context), validationContext);
        if (validationReportData != null && validationReportData.report != null && validationReportData.report.hasErrors()) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to validate Json schema for message:\n{}\nand origin path:\n{}", httpMessage.getPayload(String.class), (Object)Optional.ofNullable(httpMessage.getPath()).orElse("/"));
            }
            throw new ValidationException(this.constructErrorMessage(validationReportData));
        }
        logger.debug("Json schema validation successful: All values OK");
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return "JSON".equals(messageType) || message != null && (IsJsonPredicate.getInstance().test((String)message.getPayload(String.class)) || message.getHeader("citrus_oas_unique_operation_id") != null);
    }

    private String constructErrorMessage(ValidationReportData validationReportData) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenApi ");
        stringBuilder.append(validationReportData.type);
        stringBuilder.append(" validation failed for operation: ");
        stringBuilder.append(validationReportData.operationPathAdapter);
        validationReportData.report.getMessages().forEach(message -> stringBuilder.append("\n\t").append(message));
        return stringBuilder.toString();
    }

    private List<OpenApiRepository> findSchemaRepositories(TestContext context) {
        return new ArrayList<OpenApiRepository>(context.getReferenceResolver().resolveAll(OpenApiRepository.class).values());
    }

    @Nullable
    private ValidationReportData validate(TestContext context, HttpMessage message, List<OpenApiRepository> schemaRepositories, OpenApiMessageValidationContext validationContext) {
        String specificationId;
        List<OpenApiRepository> list = schemaRepositories = schemaRepositories != null ? schemaRepositories : Collections.emptyList();
        if (!validationContext.isSchemaValidationEnabled()) {
            return null;
        }
        String operationKey = validationContext.getSchema() != null ? validationContext.getSchema() : (String)message.getHeader("citrus_oas_unique_operation_id");
        String string = specificationId = validationContext.getSchemaRepository() != null ? validationContext.getSchemaRepository() : (String)message.getHeader("citrus_oas_unique_specification_id");
        if (StringUtils.isNotEmpty((String)specificationId) && StringUtils.isNotEmpty((String)operationKey)) {
            return this.validateOpenApiOperation(context, message, schemaRepositories, specificationId, operationKey);
        }
        return null;
    }

    private ValidationReportData validateOpenApiOperation(TestContext context, HttpMessage message, List<OpenApiRepository> schemaRepositories, String specificationId, String operationKey) {
        OpenApiSpecification openApiSpecification = schemaRepositories.stream().map(repository -> repository.openApi(specificationId)).filter(Objects::nonNull).findFirst().orElse((OpenApiSpecification)context.getVariables().get(specificationId));
        if (openApiSpecification == null) {
            throw new CitrusRuntimeException("Unable to derive OpenAPI spec for operation '%s' for validation of message from available \"\nschema repositories. Known repository aliases are: %s".formatted(operationKey, OpenApiUtils.getKnownOpenApiAliases(context.getReferenceResolver())));
        }
        OperationPathAdapter operationPathAdapter = openApiSpecification.getOperation(operationKey, context).orElseThrow(() -> new CitrusRuntimeException("Unexpectedly could not resolve operation path adapter for operationKey: " + operationKey));
        ValidationReportData validationReportData = null;
        if (this.isRequestMessage(message)) {
            ValidationReport validationReport = new OpenApiRequestValidator(openApiSpecification).validateRequestToReport(operationPathAdapter, message);
            validationReportData = new ValidationReportData(operationPathAdapter, "request", validationReport);
        } else if (this.isResponseMessage(message)) {
            ValidationReport validationReport = new OpenApiResponseValidator(openApiSpecification).validateResponseToReport(operationPathAdapter, message);
            validationReportData = new ValidationReportData(operationPathAdapter, "response", validationReport);
        }
        return validationReportData;
    }

    private boolean isResponseMessage(HttpMessage message) {
        return "citrus_oas_response".equals(message.getHeader("citrus_oas_message_type")) || message.getHeader("citrus_http_status_code") != null;
    }

    private boolean isRequestMessage(HttpMessage message) {
        return "citrus_oas_request".equals(message.getHeader("citrus_oas_message_type")) || message.getHeader("citrus_http_status_code") == null;
    }

    public boolean canValidate(Message message, boolean schemaValidationEnabled) {
        HttpMessage httpMessage;
        return schemaValidationEnabled && message instanceof HttpMessage && (this.isRequestMessage(httpMessage = (HttpMessage)message) || this.isResponseMessage(httpMessage));
    }

    public void validate(Message message, TestContext context, String schemaRepository, String schema) {
        if (!(message instanceof HttpMessage)) {
            return;
        }
        this.validate(message, context, new OpenApiMessageValidationContext.Builder().schemaValidation(true).schema(schema).schemaRepository(schemaRepository).build());
    }

    private record ValidationReportData(OperationPathAdapter operationPathAdapter, String type, ValidationReport report) {
    }
}

