/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.quarkus;

import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestCaseRunnerFactory;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.quarkus.ApplicationPropertiesSupplier;
import org.citrusframework.quarkus.CitrusSupport;

public class CitrusTestResource
implements QuarkusTestResourceConfigurableLifecycleManager<CitrusSupport> {
    private Citrus citrus;
    private TestCaseRunner runner;
    private TestContext context;
    private final Set<ApplicationPropertiesSupplier> applicationPropertiesSupplier = new HashSet<ApplicationPropertiesSupplier>();

    public void init(CitrusSupport config) {
        for (Class<? extends ApplicationPropertiesSupplier> supplierType : config.applicationPropertiesSupplier()) {
            try {
                this.registerApplicationPropertiesSupplier(supplierType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new CitrusRuntimeException("Failed to instantiate application properties supplier from type: %s".formatted(supplierType), (Throwable)e);
            }
        }
    }

    public void init(Map<String, String> initArgs) {
        String[] qualifiedClassNames;
        for (String qualifiedClassName : qualifiedClassNames = initArgs.getOrDefault("citrus.quarkus.application.properties.supplier", "").split(",")) {
            try {
                Class<?> cls = Class.forName(qualifiedClassName, true, Thread.currentThread().getContextClassLoader());
                Object instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(instance instanceof ApplicationPropertiesSupplier)) continue;
                ApplicationPropertiesSupplier supplier = (ApplicationPropertiesSupplier)instance;
                this.applicationPropertiesSupplier.add(supplier);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new CitrusRuntimeException("Failed to instantiate application property supplier from type: %s".formatted(qualifiedClassName), (Throwable)e);
            }
        }
    }

    public Map<String, String> start() {
        if (this.citrus == null) {
            this.citrus = CitrusInstanceManager.newInstance();
            this.citrus.beforeSuite("citrus-quarkus", new String[0]);
        }
        HashMap<String, String> applicationProperties = new HashMap<String, String>();
        this.applicationPropertiesSupplier.forEach(supplier -> applicationProperties.putAll((Map)supplier.get()));
        return applicationProperties;
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
        }
        this.citrus.afterSuite("citrus-quarkus", new String[0]);
        this.runner = null;
        this.context = null;
        this.applicationPropertiesSupplier.clear();
    }

    public void inject(Object testInstance) {
        if (this.runner != null) {
            this.runner.stop();
        }
        this.context = this.citrus.getCitrusContext().createTestContext();
        this.runner = TestCaseRunnerFactory.createRunner((TestContext)this.context);
        this.runner.testClass(testInstance.getClass());
        this.runner.packageName(testInstance.getClass().getPackageName());
        this.runner.name(testInstance.getClass().getSimpleName());
        this.runner.start();
        this.citrus.getCitrusContext().parseConfiguration(testInstance);
        CitrusAnnotations.injectEndpoints((Object)testInstance, (TestContext)this.context);
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.citrus, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusFramework.class, Citrus.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestActionRunner.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, GherkinTestActionRunner.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestCaseRunner.class));
        testInjector.injectIntoFields((Object)this.context, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestContext.class));
    }

    public void registerApplicationPropertiesSupplier(ApplicationPropertiesSupplier supplier) {
        this.applicationPropertiesSupplier.add(supplier);
    }
}

