/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.context.TestContext;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.openqa.selenium.WebElement;

public class CheckInputAction
extends FindElementAction {
    private final boolean checked;

    public CheckInputAction(Builder builder) {
        super("check-input", builder);
        this.checked = builder.checked;
    }

    @Override
    protected void execute(WebElement webElement, SeleniumBrowser browser, TestContext context) {
        super.execute(webElement, browser, context);
        if (webElement.isSelected() && !this.checked) {
            webElement.click();
        } else if (this.checked && !webElement.isSelected()) {
            webElement.click();
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public static class Builder
    extends FindElementAction.ElementActionBuilder<CheckInputAction, Builder> {
        private boolean checked;

        public Builder checked(boolean checked) {
            this.checked = checked;
            return this;
        }

        public CheckInputAction build() {
            return new CheckInputAction(this);
        }
    }
}

