/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.util.Set;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseWindowAction
extends AbstractSeleniumAction
implements SeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(CloseWindowAction.class);
    private final String windowName;

    public CloseWindowAction(Builder builder) {
        super("close-window", builder);
        this.windowName = builder.windowName;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (!context.getVariables().containsKey(this.windowName)) {
            throw new CitrusRuntimeException("Failed to find window handle for window " + this.windowName);
        }
        Set handles = browser.getWebDriver().getWindowHandles();
        if (!handles.contains(context.getVariable(this.windowName))) {
            throw new CitrusRuntimeException("Failed to find window for handle " + context.getVariable(this.windowName));
        }
        logger.info("Current window: " + browser.getWebDriver().getWindowHandle());
        logger.info("Window to close: " + context.getVariable(this.windowName));
        if (browser.getWebDriver().getWindowHandle().equals(context.getVariable(this.windowName))) {
            browser.getWebDriver().close();
            logger.info("Switch back to main window!");
            if (context.getVariables().containsKey("selenium_last_window")) {
                browser.getWebDriver().switchTo().window(context.getVariable("selenium_last_window"));
                context.setVariable("selenium_active_window", (Object)context.getVariable("selenium_last_window"));
            } else {
                browser.getWebDriver().switchTo().defaultContent();
                context.setVariable("selenium_active_window", (Object)browser.getWebDriver().getWindowHandle());
            }
        } else {
            String activeWindow = browser.getWebDriver().getWindowHandle();
            browser.getWebDriver().switchTo().window(context.getVariable(this.windowName));
            browser.getWebDriver().close();
            if (context.getVariables().containsKey("selenium_active_window")) {
                browser.getWebDriver().switchTo().window(context.getVariable("selenium_active_window"));
            } else {
                browser.getWebDriver().switchTo().window(activeWindow);
                context.setVariable("selenium_active_window", (Object)activeWindow);
            }
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<CloseWindowAction, Builder> {
        private String windowName = "selenium_active_window";

        public Builder window(String name) {
            this.windowName = name;
            return this;
        }

        public CloseWindowAction build() {
            return new CloseWindowAction(this);
        }
    }
}

