/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeScreenshotAction
extends AbstractSeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(MakeScreenshotAction.class);
    private final String outputDir;

    public MakeScreenshotAction(Builder builder) {
        super("screenshot", builder);
        this.outputDir = builder.outputDir;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        File screenshot = null;
        if (browser.getWebDriver() instanceof TakesScreenshot) {
            screenshot = (File)((TakesScreenshot)browser.getWebDriver()).getScreenshotAs(OutputType.FILE);
        } else {
            logger.warn("Skip screenshot action because web driver is missing screenshot features");
        }
        if (screenshot != null) {
            String testName = "Test";
            if (context.getVariables().containsKey(CitrusSettings.TEST_NAME_VARIABLE)) {
                testName = context.getVariable(CitrusSettings.TEST_NAME_VARIABLE);
            }
            context.setVariable("selenium_screenshot", (Object)(testName + "_" + screenshot.getName()));
            if (StringUtils.hasText((String)this.outputDir)) {
                try {
                    File targetDir = new File(context.replaceDynamicContentInString(this.outputDir));
                    if (!targetDir.exists() && !targetDir.mkdirs()) {
                        throw new CitrusRuntimeException("Failed to create screenshot output directory: " + this.outputDir);
                    }
                    FileUtils.copyFile((File)screenshot, (File)new File(targetDir, testName + "_" + screenshot.getName()));
                }
                catch (IOException e) {
                    logger.error("Failed to save screenshot to target storage", (Throwable)e);
                }
            } else {
                browser.storeFile(Resources.create((File)screenshot));
            }
        }
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<MakeScreenshotAction, Builder> {
        private String outputDir;

        public Builder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public MakeScreenshotAction build() {
            return new MakeScreenshotAction(this);
        }
    }
}

