/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.AlertAction;
import org.citrusframework.selenium.actions.CheckInputAction;
import org.citrusframework.selenium.actions.ClearBrowserCacheAction;
import org.citrusframework.selenium.actions.ClickAction;
import org.citrusframework.selenium.actions.CloseWindowAction;
import org.citrusframework.selenium.actions.DropDownSelectAction;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.actions.GetStoredFileAction;
import org.citrusframework.selenium.actions.HoverAction;
import org.citrusframework.selenium.actions.JavaScriptAction;
import org.citrusframework.selenium.actions.MakeScreenshotAction;
import org.citrusframework.selenium.actions.NavigateAction;
import org.citrusframework.selenium.actions.OpenWindowAction;
import org.citrusframework.selenium.actions.PageAction;
import org.citrusframework.selenium.actions.SeleniumAction;
import org.citrusframework.selenium.actions.SetInputAction;
import org.citrusframework.selenium.actions.StartBrowserAction;
import org.citrusframework.selenium.actions.StopBrowserAction;
import org.citrusframework.selenium.actions.StoreFileAction;
import org.citrusframework.selenium.actions.SwitchWindowAction;
import org.citrusframework.selenium.actions.WaitUntilAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.selenium.model.WebPage;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.ObjectHelper;

public class SeleniumActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<SeleniumAction> {
    private SeleniumBrowser seleniumBrowser;
    private AbstractSeleniumAction.Builder<? extends SeleniumAction, ?> delegate;

    public static SeleniumActionBuilder selenium() {
        return new SeleniumActionBuilder();
    }

    public SeleniumActionBuilder browser(SeleniumBrowser seleniumBrowser) {
        this.seleniumBrowser = seleniumBrowser;
        return this;
    }

    public StartBrowserAction.Builder start() {
        StartBrowserAction.Builder builder;
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StartBrowserAction.Builder start(SeleniumBrowser seleniumBrowser) {
        StartBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop() {
        StopBrowserAction.Builder builder;
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop(SeleniumBrowser seleniumBrowser) {
        StopBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public AlertAction.Builder alert() {
        AlertAction.Builder builder;
        this.delegate = builder = (AlertAction.Builder)((Object)new AlertAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public NavigateAction.Builder navigate() {
        NavigateAction.Builder builder;
        this.delegate = builder = (NavigateAction.Builder)((Object)new NavigateAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public NavigateAction.Builder navigate(String page) {
        NavigateAction.Builder builder;
        this.delegate = builder = (NavigateAction.Builder)((Object)new NavigateAction.Builder().page(page).browser(this.seleniumBrowser));
        return builder;
    }

    public PageAction.Builder page(WebPage page) {
        PageAction.Builder builder;
        this.delegate = builder = (PageAction.Builder)((Object)new PageAction.Builder().page(page).browser(this.seleniumBrowser));
        return builder;
    }

    public PageAction.Builder page(Class<? extends WebPage> pageType) {
        PageAction.Builder builder;
        this.delegate = builder = (PageAction.Builder)((Object)new PageAction.Builder().type(pageType).browser(this.seleniumBrowser));
        return builder;
    }

    public FindElementAction.Builder find() {
        FindElementAction.Builder builder;
        this.delegate = builder = (FindElementAction.Builder)((Object)new FindElementAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public DropDownSelectAction.Builder select(String option) {
        DropDownSelectAction.Builder builder;
        this.delegate = builder = (DropDownSelectAction.Builder)((Object)new DropDownSelectAction.Builder().option(option).browser(this.seleniumBrowser));
        return builder;
    }

    public DropDownSelectAction.Builder select(String ... options) {
        DropDownSelectAction.Builder builder;
        this.delegate = builder = (DropDownSelectAction.Builder)((Object)new DropDownSelectAction.Builder().options(options).browser(this.seleniumBrowser));
        return builder;
    }

    public SetInputAction.Builder setInput(String value) {
        SetInputAction.Builder builder;
        this.delegate = builder = (SetInputAction.Builder)((Object)new SetInputAction.Builder().value(value).browser(this.seleniumBrowser));
        return builder;
    }

    public SetInputAction.Builder setInput() {
        SetInputAction.Builder builder;
        this.delegate = builder = (SetInputAction.Builder)((Object)new SetInputAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CheckInputAction.Builder checkInput() {
        CheckInputAction.Builder builder;
        this.delegate = builder = (CheckInputAction.Builder)((Object)new CheckInputAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CheckInputAction.Builder checkInput(boolean checked) {
        CheckInputAction.Builder builder;
        this.delegate = builder = (CheckInputAction.Builder)((Object)new CheckInputAction.Builder().checked(checked).browser(this.seleniumBrowser));
        return builder;
    }

    public ClickAction.Builder click() {
        ClickAction.Builder builder;
        this.delegate = builder = (ClickAction.Builder)((Object)new ClickAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public HoverAction.Builder hover() {
        HoverAction.Builder builder;
        this.delegate = builder = (HoverAction.Builder)((Object)new HoverAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public ClearBrowserCacheAction.Builder clearCache() {
        ClearBrowserCacheAction.Builder builder;
        this.delegate = builder = (ClearBrowserCacheAction.Builder)((Object)new ClearBrowserCacheAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public MakeScreenshotAction.Builder screenshot() {
        MakeScreenshotAction.Builder builder;
        this.delegate = builder = (MakeScreenshotAction.Builder)((Object)new MakeScreenshotAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public MakeScreenshotAction.Builder screenshot(String outputDir) {
        MakeScreenshotAction.Builder builder;
        this.delegate = builder = (MakeScreenshotAction.Builder)((Object)new MakeScreenshotAction.Builder().outputDir(outputDir).browser(this.seleniumBrowser));
        return builder;
    }

    public StoreFileAction.Builder store() {
        StoreFileAction.Builder builder;
        this.delegate = builder = (StoreFileAction.Builder)((Object)new StoreFileAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StoreFileAction.Builder store(String filePath) {
        StoreFileAction.Builder builder;
        this.delegate = builder = (StoreFileAction.Builder)((Object)new StoreFileAction.Builder().filePath(filePath).browser(this.seleniumBrowser));
        return builder;
    }

    public GetStoredFileAction.Builder getStored() {
        GetStoredFileAction.Builder builder;
        this.delegate = builder = (GetStoredFileAction.Builder)((Object)new GetStoredFileAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public GetStoredFileAction.Builder getStored(String fileName) {
        GetStoredFileAction.Builder builder;
        this.delegate = builder = (GetStoredFileAction.Builder)((Object)new GetStoredFileAction.Builder().fileName(fileName).browser(this.seleniumBrowser));
        return builder;
    }

    public WaitUntilAction.Builder waitUntil() {
        WaitUntilAction.Builder builder;
        this.delegate = builder = (WaitUntilAction.Builder)((Object)new WaitUntilAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript() {
        JavaScriptAction.Builder builder;
        this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript(String script) {
        JavaScriptAction.Builder builder;
        this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().script(script).browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript(Resource script) {
        return this.javascript(script, FileUtils.getDefaultCharset());
    }

    public JavaScriptAction.Builder javascript(Resource scriptResource, Charset charset) {
        try {
            JavaScriptAction.Builder builder;
            this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().script(FileUtils.readToString((Resource)scriptResource, (Charset)charset)).browser(this.seleniumBrowser));
            return builder;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource", (Throwable)e);
        }
    }

    public OpenWindowAction.Builder open() {
        OpenWindowAction.Builder builder;
        this.delegate = builder = (OpenWindowAction.Builder)((Object)new OpenWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CloseWindowAction.Builder close() {
        CloseWindowAction.Builder builder;
        this.delegate = builder = (CloseWindowAction.Builder)((Object)new CloseWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SwitchWindowAction.Builder focus() {
        SwitchWindowAction.Builder builder;
        this.delegate = builder = (SwitchWindowAction.Builder)((Object)new SwitchWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SwitchWindowAction.Builder switchWindow() {
        SwitchWindowAction.Builder builder;
        this.delegate = builder = (SwitchWindowAction.Builder)((Object)new SwitchWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SeleniumAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        if (this.seleniumBrowser != null) {
            this.delegate.browser(this.seleniumBrowser);
        }
        return (SeleniumAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }
}

