/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import org.citrusframework.context.TestContext;
import org.citrusframework.selenium.actions.AbstractSeleniumAction;
import org.citrusframework.selenium.actions.NavigateAction;
import org.citrusframework.selenium.actions.OpenWindowAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartBrowserAction
extends AbstractSeleniumAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenWindowAction.class);
    private final boolean allowAlreadyStarted;

    public StartBrowserAction(Builder builder) {
        super("start", builder);
        this.allowAlreadyStarted = builder.allowAlreadyStarted;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (!this.allowAlreadyStarted && browser.isStarted()) {
            logger.warn("There are some open web browsers. They will be stopped.");
            browser.stop();
        } else if (browser.isStarted()) {
            logger.info("Browser already started - skip start action");
            context.setVariable("selenium_browser", (Object)browser.getName());
            return;
        }
        logger.info("Opening browser of type {}", (Object)browser.getEndpointConfiguration().getBrowserType());
        browser.start();
        if (StringUtils.hasText((String)this.getBrowser().getEndpointConfiguration().getStartPageUrl())) {
            NavigateAction openStartPage = new NavigateAction.Builder().page(this.getBrowser().getEndpointConfiguration().getStartPageUrl()).build();
            openStartPage.execute(browser, context);
        }
        context.setVariable("selenium_browser", (Object)browser.getName());
    }

    public boolean isAllowAlreadyStarted() {
        return this.allowAlreadyStarted;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<StartBrowserAction, Builder> {
        private boolean allowAlreadyStarted = true;

        public Builder allowAlreadyStarted(boolean permisson) {
            this.allowAlreadyStarted = permisson;
            return this;
        }

        public StartBrowserAction build() {
            return new StartBrowserAction(this);
        }
    }
}

