/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.actions;

import java.time.Duration;
import java.util.function.Function;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.selenium.actions.FindElementAction;
import org.citrusframework.selenium.endpoint.SeleniumBrowser;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitUntilAction
extends FindElementAction {
    private final Long timeout;
    private final String condition;

    public WaitUntilAction(Builder builder) {
        super("wait", builder);
        this.timeout = builder.timeout;
        this.condition = builder.condition;
    }

    @Override
    protected void execute(WebElement webElement, SeleniumBrowser browser, TestContext context) {
        WebDriverWait q = new WebDriverWait(browser.getWebDriver(), Duration.ofMillis(this.timeout));
        if (this.condition.equals("hidden")) {
            q.until((Function)ExpectedConditions.invisibilityOf((WebElement)webElement));
        } else if (this.condition.equals("visible")) {
            q.until((Function)ExpectedConditions.visibilityOf((WebElement)webElement));
        } else {
            throw new CitrusRuntimeException("Unknown wait condition");
        }
    }

    @Override
    protected void validate(WebElement element, SeleniumBrowser browser, TestContext context) {
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getCondition() {
        return this.condition;
    }

    public static class Builder
    extends FindElementAction.ElementActionBuilder<WaitUntilAction, Builder> {
        private Long timeout = 5000L;
        private String condition;

        public Builder visible() {
            this.condition("visible");
            return this;
        }

        public Builder hidden() {
            this.condition("hidden");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public WaitUntilAction build() {
            return new WaitUntilAction(this);
        }
    }
}

