/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.selenium.config.xml;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.selenium.actions.PageAction;
import org.citrusframework.selenium.config.xml.AbstractBrowserActionParser;
import org.citrusframework.selenium.model.PageValidator;
import org.citrusframework.selenium.model.WebPage;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PageActionParser
extends AbstractBrowserActionParser {
    @Override
    protected void parseAction(BeanDefinitionBuilder beanDefinition, Element element, ParserContext parserContext) {
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("name"), (String)"page");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("type"), (String)"type");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("action"), (String)"action");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("validator"), (String)"validator");
        ArrayList<String> arguments = new ArrayList<String>();
        Element argumentsContainer = DomUtils.getChildElementByTagName((Element)element, (String)"arguments");
        if (argumentsContainer != null) {
            List argumentElements = DomUtils.getChildElementsByTagName((Element)argumentsContainer, (String)"argument");
            for (Element argument : argumentElements) {
                arguments.add(DomUtils.getTextValue((Element)argument));
            }
            beanDefinition.addPropertyValue("arguments", arguments);
        }
    }

    protected Class<PageActionFactoryBean> getBrowserActionClass() {
        return PageActionFactoryBean.class;
    }

    public static class PageActionFactoryBean
    extends AbstractBrowserActionParser.AbstractSeleniumActionFactoryBean<PageAction, PageAction.Builder> {
        private final PageAction.Builder builder = new PageAction.Builder();

        public void setPage(WebPage page) {
            this.builder.page(page);
        }

        public void setAction(String action) {
            this.builder.action(action);
        }

        public void setValidator(PageValidator validator) {
            this.builder.validator(validator);
        }

        public void setType(String type) {
            this.builder.type(type);
        }

        public void setArguments(List<String> arguments) {
            this.builder.arguments(arguments);
        }

        public PageAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return PageAction.class;
        }

        public PageAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

